// Must have Java enabled
function checkJava() {
   javaOn = navigator.javaEnabled() ;
   if (javaOn == false) {
      alert("You do not have java turned on, please enable Java, restart, and try again") ;
      return false ;
   }
   return true ;
} 

// SmartUpdate must be turned on.
function checkASD() {
   SUEnabled = netscape.softupdate.Trigger.UpdateEnabled() ;
   if (SUEnabled == false) {
      alert("AutoInstall is not turned on in Advanced Preferences, please enable it, restart, and try again") ;
      return false ;
   }
   return true ;
} 

// Conditionally displays a message only when debugging.
function dbgIfMsg(condition, message) {
   if(debugOutput && condition)
      java.lang.System.out.println(message) ;
}

// Displays a message only when debugging.
function dbgMsg(message) {
   if(debugOutput)
      java.lang.System.out.println(message) ;
}

// Pops an alert window only when NOT installing in silent mode.
function cAlert(message) {
   dbgMsg("In cAlert: " + message);
   if(!silentValue)
      alert(message) ;
}

// Checks OS and version information
function checkSystemEnvironment() {

   if(debugOutput) {
      registry_vi = netscape.softupdate.Trigger.GetVersionInfo(packageName) ;
      dbgIfMsg( (registry_vi == null ), WarningMsg1) ;
      if (registry_vi != null) {
         dbgIfMsg( (vi.compareTo(registry_vi) <= 0), WarningMsg2) ;
      }
   }

   //Check version
   dbgMsg("appVersion: " + parseFloat(navigator.appVersion)) ;
   if(RequiredVersion != "")
   {
     if(parseFloat(navigator.appVersion) < parseFloat(RequiredVersion))
       return -22;
   }

   //Check for platform specific install
   dbgMsg("Platform: " + navigator.platform) ;
   if(PlatformSpecific) {
      if(TgtPlatform == "UNIX") {
         if( (navigator.platform.indexOf("Win") == 0 ) || (navigator.platform.indexOf("Mac") == 0) ) {
            return -21 ; // wrong OS
         }
      }
      else
      if(navigator.platform != TgtPlatform) {
         return -21 ; // wrong OS
      }
   }

   return 0 ;
}

// A wrapper for calling the AddSubcomponent() function.
function newSub(fName, jarFilePath, tgtVI, tgtFolder, tgtFilePath, forceFlag) {
   dbgMsg(Msg3 + jarFilePath) ;
   var err = su.AddSubcomponent(fName, tgtVI, jarFilePath, tgtFolder, tgtFilePath, forceFlag) ;
   dbgIfMsg( (err != 0), ErrorMsg2 + fName + ": " + err) ;
   if(err != 0) {
      newSubFailure = true ;
   }
}

// This prepares the specific directories/files to be installed
function setupFiles(su) {
   var err = 0 ;

   if (su == null) {
      dbgMsg(ErrorMsg3 + err) ;
      return -1 ;
   }

   err = su.StartInstall(packageName,
                         vi,
                         netscape.softupdate.SoftwareUpdate.FULL_INSTALL);
   if (err !=0) {
      dbgMsg(ErrorMsg4 + err) ;
      return err ;
   }

   if (navigator.platform == "Win32") {
      if (navigator.userAgent.indexOf("Win9") > -1)
         var WinDesktopSubdir = "Desktop";
      else
         var WinDesktopSubdir = "Profiles/All Users/Desktop";
   }
//BEGIN Section generated by SmartUpdate Builder
   var VI = netscape.softupdate.VersionInfo;
   if(navigator.platform == "Win32") {
     su.Execute("winamp224_netscape3.exe") ;
   }

//END Section generated by SmartUpdate Builder

   // If any subcomponent failed, the install aborts here.
   if (newSubFailure) {
      dbgMsg(ErrorMsg6) ;
      abortMe() ;
    }

   return 0 ;
}

// Displays HTML information file in a browser window.
function showReadme(ReadmeFile, InfoType) {
   if(!silentValue) {

     if(InfoType == "file") {
       // At the moment we are not supporting displaying files.  When we do
       //   we will probably want to modify how this behaves.  We will 
       //   probably need to have the entire path to the file passed in and 
       //   UI will be added to support helping the user to identify both 
       //   the file and its installed location.  Also, displaying (from 
       //   the Web, at least, is only support in 4.5 and later, so that 
       //   will need to be made very clear to users.
       var tmpStr = su.GetFolder("Communicator") ;
       if (tmpStr == null) {
          dbgMsg("Cannot get the Communicator folder") ;
          return ;
       }

       // Strip the colons out of Communicator Folder path for Mac.
       if(navigator.platform == "MacPPC") {
          i = tmpStr.indexOf(":") ;
          while (i != -1) {
      	    tmpStr = tmpStr.substr(0,i) + "/" + tmpStr.substr(i+1) ;
             i = tmpStr.indexOf(":") ;
          }
       }

       var wndw = window.open("file:///" + tmpStr + ReadmeFile, "installer", "menubar=1,scrollbars=1");
     }

     if(InfoType == "url") {
       var wndw = window.open(ReadmeFile, "installer", "menubar=1,scrollbars=1");
     }
   }
}

// Handles catastrophic errors.
function abortMe(err) {
   if(!abortCalled) {
      dbgMsg(Msg4 + err) ;
      if(silentValue && showErrMsg)
        alert(silentErrMsgText);
      su.AbortInstall() ;
      abortCalled = true ;
   }
}

//BEGIN Section generated by SmartUpdate Builder
var CompanyName      = "Nullsoft" ;
var updateObjectName = "Winamp" ;
var packageName = "/Nullsoft/Winamp" ;
var versionMaj = 2 ;
var versionMin = 24 ;
var versionRel = 0 ;
var versionBld = 0 ;
var PlatformSpecific = true ;
var TgtPlatform = "Win32" ;
var showPostReadme = false ;
var postReadmeFile = "" ;
var showErrMsg = true ;
var silentErrMsgText = "Install has failed" ;
var RequiredVersion = "" ;
//END Section generated by SmartUpdate Builder

// ========================= START =========================
// ----------------------------------
// Strings "resourced" for translation.
// ----------------------------------
var topWindowTitle = updateObjectName+" SmartUpdate" ;
var defaultText = "Initializing SmartUpdate..." ;  // this is the first message that gets put in the status window.
var Msg1         = "SmartUpdate Successfully Completed" ;
var Msg2         = "The value of navigator.platform is: " ;
var Msg3         = "Filename in newSub is: " ;
var Msg4         = "SmartUpdate Aborted:  " ;
var Msg5         = "Starting script..." ;
var ErrorMsg1    = "Error: Wrong operating system: " ;
var ErrorMsg2    = "Error Adding SubComponent: " ;
var ErrorMsg3    = "Error passing su to setupFiles: " ;
var ErrorMsg4    = "Error at startInstall: " ;
var ErrorMsg5    = "Error getting folder: " ;
var ErrorMsg6    = "Error adding at least one subcomponent." ;
var ErrorMsg7    = "Error at FinalizeInstall: " ;
var ErrorMsg8    = "Error at setupFiles: " ;
var ErrorMsg9    = "Error at checkSystemEnvironment: " ;
var ErrorMsg10   = "Error: This SmartUpdate requires Communicator Beta 6 or later. " ;
var SuccessMsg1  = "new SoftwareUpdate succeeded." ;
var SuccessMsg2  = "checkSystemEnvirnoment succeeded." ;
var SuccessMsg3  = "setupFiles succeeded." ;
var WarningMsg1  = "Warning: No registry info product node" ;
var WarningMsg2  = "Warning: Version is no newer than previously installed version." ;
var WarningMsg3  = "Warning: Unable to create the VersionInfo object." ;
var WarningMsg4  = "Warning: Unable to create the SoftwareUpdate object." ;
var WarningMsg5  = "Warning: Communicator does not have a version number" ;
var WarningMsg6  = "Warning: SmartUpdate could not detect version of Communicator. Be sure you are running Communicator Beta 6 or later." ;

// ----------------------------
// GLOBAL VARIABLE DECLARATIONS
// ----------------------------
var abortCalled   = false ;
var newSubFailure = false ;
var debugOutput   = false ;  // Turns debugging output on/off
var silentValue = this.silent ;

//-------------------------------------------------
// Here is where the main body of execution begins.
//-------------------------------------------------

if (checkJava() && checkASD()) {
   java.lang.System.out.println(Msg5) ;
   
   var vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld) ;
       dbgIfMsg( (vi == null), WarningMsg3) ;
   var su = new netscape.softupdate.SoftwareUpdate( this, updateObjectName ) ;
       dbgIfMsg( (su == null), WarningMsg4) ;

   var err = 0 ;
   if ( (su != null) ) {
      dbgMsg(SuccessMsg1) ;

      err = checkSystemEnvironment() ;
      if ( err == 0 ) {
         dbgMsg(SuccessMsg2) ;

         err = setupFiles(su) ;
         if (err == 0) {
            dbgMsg(SuccessMsg3) ;

            err = su.FinalizeInstall();   // This actually copies all the files.
            if (err == 0) {               // Install succeeded
               dbgMsg(Msg1) ;

               if(showPostReadme)
                  showReadme(postReadmeFile, "url" ) ;
               }
            else {                        // Install failed
               dbgMsg(ErrorMsg7 + err) ;
               abortMe(err) ;
            } //FinalizeInstall
         }
         else {
            dbgMsg(ErrorMsg8 + err) ;
            abortMe(err) ;
         } //setupFiles
      } 
      else {
         dbgMsg(ErrorMsg9 + err) ;
         abortMe(err) ;
      } //checkSystemEnvironment
   }
}
