
// PARABLE ThingViewer for Netscape
// JIM File.

// Larry Kyrala  5/19/98
// adapted from Netscape's tech docs on JIM.
// -----------------------------------------



// Conditional alert.
function cAlert (message) {
   if (!this.silent)
      alert(message);
}

// Conditional confirm.
function cConfirm (message) {
   if (this.silent)
      return true;
   else
      return confirm(message);
}

// Variable indicating whether or not installation should proceed.
bInstall = true;

// Make sure Java is enabled before doing anything else.
if ( !navigator.javaEnabled() ) 
{
   bInstall = false;
   cAlert ("Java must be enabled to install.");
}

// Make sure installation is attempted on correct machine architecture.
else if ( navigator.platform != "Win32" ) 
{
   bInstall = false;
   cAlert ("This plug-in only runs on Win32 platforms.");
}

// Check user-interface language, if appropriate.
else if ( navigator.language != "en" ) 
{
   bInstall = cConfirm("This plug-in uses the English language. You do not appear to be using English on this machine. Install anyway?");
}



// If all conditions look good, proceed with the installation.
if (bInstall) 
{

   bAbort = false;
   errMsg = "";


   // Create a version object and a software update object
   vi = new netscape.softupdate.VersionInfo(1, 0, 0, 1);
   su = new netscape.softupdate.SoftwareUpdate(this, "ThingViewer for Netscape");


   // Start the install process
   err = su.StartInstall("plugins/Parable/ThingViewer/", vi, netscape.softupdate.SoftwareUpdate.FULL_INSTALL);

				

   if (err != 0)
   {			
	  if (err != -202)   // ACCESS_DENIED  (don't alert if the user didn't grant permission)
	  {
         errMsg = "An installation error occurred. Aborting install.\n[ error code: " + err + " ]";
		 cAlert( errMsg );
	  }
	  bAbort = true;
   }
   else 
   {
      // Unpack the native installer found in the JAR archive to
	  // a temporary location
	  su.Execute("ThingViewer_Install_Netscape.exe");
   }


   // Unless there was a problem, move files to final location 
   // and update the Client Version Registry
   if (bAbort) 
   {
      su.AbortInstall();
   }
   else 
   {
      err = su.FinalizeInstall();

      // Refresh list of available plug-ins
      if (err == 0)
         navigator.plugins.refresh(true);
      else if (err == 999)			// RESTART_REQUIRED
         cAlert("You must reboot to finish this installation.");
	  else if (err != -210)         // USER_CANCELED
	  {
         errMsg = "An installation error occurred.\n[ error code: " + err + " ]";
		 cAlert( errMsg );
	  }
   }


}
