// Detonator install.js
// copyright (c) Macromedia, Inc.
// version 1.0b1
// Oct 23, 1997

// original code by Patrick Callahan
// modified by Chris Walcott
// 98% rewritten by Mike Seery


//  Specify whether to present a status window to the user.
//
//  Flash-only JARs should be silent (i.e. no extra windows).
//  So, if you're making a Flash-only JAR, set gSilentInstall to TRUE.
//  For Director-only, or Director & Flash combined JARs, set it to FALSE.

var gSilentInstall = false;
//  var gSilentInstall = this.silent;


//  Establish which plug-ins will be installed.
//
//  If you want a Director-only JAR file, set gDirectorInstall to TRUE and gFlashInstall to FALSE.
//  If you want a Flash-only JAR file, set gDirectorInstall to FALSE and gFlashInstall to TRUE.
//  If you want a JAR file with Director & Flash combined, set both variables to TRUE.

var gDirectorInstall	= true;
var gFlashInstall		= false;



//  Identify the Shockwave plug-in versions.
//
//  Right-click on the Windows plug-in and check the "File version" info in the properties menu.
//  And in the Finder, "Get Info" on the Macintosh plug-in.
//  The version *should* match the current build number, unless there's a build problem.
//  Don't release any files until you're certain they have the correct version resource.

var gFlashVersionString		= "3,0,8,0";
var gDirectorVersionString	= "6,0,1,117";



//  Provide the filenames of each Shockwave component.
//
//  FIRST: you *must* use proper CApiTAliZAtiON.
//  The JAR Installation Manager is case-sensitive.
//  If a filename you input here differs from the one in the JAR file, NETSCAPE WILL SKIP IT.
//  And this is important: you can't trust a filename's capitalization as it is shown in Windows.
//  The only sure way to check a file's capitalization is to view it in a DOS window.
//  In the MS-DOS Command Prompt, doublecheck the filenames against the lists you type here.
//
//  SECOND: folder names end in a forward slash "/".
//  This is how the JAR Installation Manager defines its platform-independent file separator.
//
//  THIRD: what the different variables are for.
//
//       variable name                    ultimate destination of its contents
//       -------------                    ------------------------------------
//       gFlashPluginFiles                the Netscape plug-ins folder
//                                        /plugins/
//
//       gDirectorPluginFiles             the Netscape plug-ins folder
//                                        /plugins/
//
//       gDirectorShockwaveFolderFiles    the Shockwave Director subfolder (in the plugins folder)
//                                        /plugins/[gDirectorShockwaveFolderName]/
//
//       gDirectorXtrasFolderFiles        the Xtras folder (in the Shockwave Director folder)
//                                        /plugins/[gDirectorShockwaveFolderName]/Xtras/
//
//       gDirectorShockwaveFolderName     Shockwave Director subfolder name (platform dependent)

var gUserOS = navigator.platform;
if ( gUserOS == "Win32" )
{
	var gFlashPluginFiles				= "NPSWF32.DLL";
	var gFlashShockwaveFolderFiles		= "";
	var gFlashXtrasFolderFiles			= "";
	var gFlashShockwaveFolderName		= "";

	var gDirectorPluginFiles			= "NP32DSW.DLL, ShockwavePlugin.class, ShockwaveReadmeNS.htm";
	var gDirectorShockwaveFolderFiles	= "DIRAPI.DLL, IDLE32.EXE, IML32.DLL, PLUGIN32.DLL";
	var gDirectorXtrasFolderFiles		= "SWADCMPR.X32, SWASTRM.X32";
	var gDirectorShockwaveFolderName	= "NP32DSW/";
}
else if ( gUserOS == "Win16" )
{
	var gFlashPluginFiles				= "NPSWF16.DLL";
	var gFlashShockwaveFolderFiles		= "";
	var gFlashXtrasFolderFiles			= "";
	var gFlashShockwaveFolderName		= "";

	var gDirectorPluginFiles			= "NP16DSW.DLL, swReadme.htm";
	var gDirectorShockwaveFolderFiles	= "DIRAPI.DLL, DIRDIB.DRV, IDLE16.EXE, IML.DLL, MACROMIX.DLL, PLUGIN16.DLL";
	var gDirectorXtrasFolderFiles		= "SWADCMPR.X16, SWASTRM.X16";
	var gDirectorShockwaveFolderName	= "NP16DSW/";
}
else if ( gUserOS == "MacPPC" )
{
	var gFlashPluginFiles				= "Shockwave Flash NP-PPC";
	var gFlashShockwaveFolderFiles		= "";
	var gFlashXtrasFolderFiles			= "";
	var gFlashShockwaveFolderName		= "";

	var gDirectorPluginFiles			= "NP-PPC-Dir-Shockwave, IMLlib, ShockwavePlugin.class, ShockwaveReadmeNS.htm";
	var gDirectorShockwaveFolderFiles	= "";
	var gDirectorXtrasFolderFiles		= "SWA Decompression PPC Xtra, SWA Streaming PPC Xtra";
	var gDirectorShockwaveFolderName	= "NP-PPC-Dir-Shockwave Folder/";
}
else if ( gUserOS == "Mac68K" )
{
	var gFlashPluginFiles				= "Shockwave Flash NP-68K";
	var gFlashShockwaveFolderFiles		= "";
	var gFlashXtrasFolderFiles			= "";
	var gFlashShockwaveFolderName		= "";

	var gDirectorPluginFiles			= "NP-68K-Dir-Shockwave, ShockwaveReadmeNS.htm";
	var gDirectorShockwaveFolderFiles	= "";
	var gDirectorXtrasFolderFiles		= "SWA Decompression 68K Xtra, SWA Streaming 68K Xtra";
	var gDirectorShockwaveFolderName	= "NP-68K-Dir-Shockwave Folder/";
}



//  Identify the Netscape Plug-in Registry keys.
//
//  These are the names for our entries in the Netscape Plug-in Registry.
//  Don't confuse this with the Windows Registry.  It's entirely different.
//  The Netscape registry keeps track of version info on every installed plug-in.
//  It is *highly unlikely* that these values will *ever* need changing, but it's not impossible.

var gFlashRegistryName		= "plugins/Macromedia Shockwave/Flash";
var gDirectorRegistryName	= "plugins/Macromedia Shockwave/Director";









//  -------------------------------------------------------------
//
//                        N  O  T  I  C  E
//
//
//  Change nothing below this comment.
//
//  To use this script inside functional Shockwave JAR files,
//  you need to change only the variables located above.
//
//  -------------------------------------------------------------








// ================ JAVA CONSOLE ================

function debug( debugString )
{
	if ( true )
	{
		java.lang.System.out.println( debugString );
	}
}




// ================ LIST FUNCTIONS =======================

function count( list )
{
	var itemCount = 0;

	if ( list != null )
	{
		var itemDelimiter	= ",";
		var whitespace		= " ";

		var c = "";
		var validItem = false;
	
		var len = list.length;
		for ( var i = 0; i < len; i++ )
		{
			c = list.charAt( i );
			if ( c == itemDelimiter )
			{
				if ( validItem )
				{
					itemCount++;
					validItem = false;
				}
			}
			else if ( c != whitespace )
			{
				validItem = true;
			}
		}

		if ( validItem )
			itemCount++;
	}

	return itemCount;
}


function getAt( list, index )
// still need to strip trailing whitespace
{
	var currentItem = null;

	var withinBounds = (( index > 0 ) && ( index <= count( list )));
	if ( withinBounds )
	{
		var itemDelimiter	= ",";
		var whitespace		= " ";

		var c = "";
		var currentItem = "";
		var validItem = false;
		var itemCount = 0;

		var len = list.length;
		for ( var i = 0; i < len; i++ )
		{
			c = list.charAt( i );
			if ( c == itemDelimiter )
			{
				if ( validItem )
				{
					itemCount++;
					if ( itemCount == index )
					{
						return currentItem;
					}
					validItem = false;
					currentItem = "";
				}
			}
			else if ( c == whitespace )
			{
				if ( validItem )
				{
					currentItem += c;
				}
			}
			else
			{
				validItem = true;
				currentItem += c;
			}
		}
	}

	return currentItem;
}



// ================ BUILT-IN DIALOG WINDOW ================

function delay( totalSeconds )
{
	if ( totalSeconds > 0 )
	{
		var currTime	= new Date();
		var currSeconds	= currTime.getSeconds();
		var target		= ( currSeconds + totalSeconds ) % 60;

		while ( currSeconds != target )
		{
			currTime	= new Date();
			currSeconds	= currTime.getSeconds();
		}
	}

	return null;
}


function getBuiltInFrame( whichFrame )
{
	var theFrame = null;

	if ( gBuiltInWindow != null )
	{
		if (( whichFrame > -1 ) && ( whichFrame < gBuiltInWindow.frames.length ))
		{
			theFrame = gBuiltInWindow.frames[ whichFrame ];
		}
	}

	return theFrame;
}


function writeFrame( frameNum, documentText )
{
	var myFrame = getBuiltInFrame( frameNum );
	if ( myFrame != null )
		myFrame.document.write( documentText );
}


function closeFrame( frameNum )
{
	var myFrame = getBuiltInFrame( frameNum );
	if ( myFrame != null )
		myFrame.document.close();
}


function setupWindow( topWindowTitle )
{
	var windowWidth		= 480;
	var windowHeight	= 280;
	var screenSize		= java.awt.Toolkit.getDefaultToolkit().getScreenSize();

	var windowTop = ( screenSize.height - windowHeight ) / 2;
	if ( windowTop < 0 ) windowTop = 0;

	var windowLeft = ( screenSize.width - windowWidth ) / 2;
	if ( windowLeft < 0 ) windowLeft = 0;

	var temp;

	temp = "toolbar=0,menubar=0,status=0,directories=0,location=0,scrollbars=0,resizable=0";
	temp += ",width=" + windowWidth + ",height=" + windowHeight;
	temp += ",top=" + windowTop + ",left=" + windowLeft;

	gBuiltInWindow = window.open( "", "installer", temp );
	gBuiltInWindow.document.open( "text/html" );
	gBuiltInWindow.document.close();

	// create the frameset document:
	temp  = '<TITLE>' + topWindowTitle + '</TITLE>';
	temp += '<FRAMESET ROWS="50%,50%" border=0 frameborder="no" marginwidth=0>';
	temp += '<FRAME SRC="about:blank" NAME="TOP">';
	temp += '<FRAME SRC="about:blank" NAME="BOTTOM">';
	temp += '</FRAMESET>';

	gBuiltInWindow.document.write( temp );
	gBuiltInWindow.document.close();

	// an effort to clean the window of background schmutz:
	temp = "<center><br><br><h3></h3></center>";

	writeFrame( 0, temp );
	closeFrame( 0 );

	writeFrame( 1, temp );
	closeFrame( 1 );


	// put text into the window first, then update it with a graphic.
	temp  = '<HTML><BODY><CENTER>';
	temp += '<IMG SRC="http://www.macromedia.com/images/mwm.small.gif">';
	temp += '<H4>' + topWindowTitle + '</H4>';
	temp += '</CENTER></BODY></HTML>';

	writeFrame( 0, temp );

	return null;
}


function updateStatusText( text, hSize, totalSeconds )
{
	if ( !gSilentInstall )
	{
		// if the window isn't open, then OPEN IT
		if ( gBuiltInWindow == null )
			setupWindow( "Shockwave Installer" );

		closeFrame( 1 );
		
		temp  = '<HTML><BODY><CENTER><FONT FACE="Arial, Helvetica" SIZE=5 COLOR=BLUE>';
		temp += '<BR><H' + hSize + '>' + text + '</H' + hSize + '>';
		temp += '<BR></CENTER></BODY></HTML>';

		writeFrame( 1, temp );
		closeFrame( 1 );

		delay( totalSeconds );
	}

	return null;
}




// ================ EXTERNAL SHOCKWAVE STATUS WINDOW ================

function getDetonatorWindow()
{
//	return window.open( "about:blank", "ShockwaveStatus", "" );
	return window.open( "", "ShockwaveStatus", "" );
}


function getStatusWindow()
{
	var detonatorWindow = getDetonatorWindow();

	debug( 'detonatorWindow = "' + detonatorWindow + '"' );

	if ( detonatorWindow != null )
	{
		debug( 'about to query detonatorWindow.document...' );
		var windowDoc = detonatorWindow.document;
		debug( 'windowDoc = "' + windowDoc + '"' );

		debug( 'about to query detonatorWindow.document.images...' );
		var windowImages = detonatorWindow.document.images;
		debug( 'windowImages = "' + windowImages + '"' );

		debug( 'about to query detonatorWindow.document.images.length...' );
		var windowImageCount = detonatorWindow.document.images.length;
		debug( 'windowImageCount = "' + windowImageCount + '"' );

		if ( windowImageCount != 0 )
		{
			return detonatorWindow;
		}
		else
		{
			detonatorWindow.close();
		}
	}

	gDetonatorWindowOK = false;
	return null;
}


function statusNewPage( thePage, theString )
{
	if ( theString != "" )
	{
		thePage += "?" + theString;
	}

	debug( thePage );

	if ( !gSilentInstall )
	{
		if ( gDetonatorWindowOK )
		{
			var statusWindow = getStatusWindow();
			if ( statusWindow != null )
				statusWindow.location.replace( thePage );
		}

		if ( !gDetonatorWindowOK )
			updateStatusText( theString, 4, 1 );
	}
}


function statusUpdate( theString )
{
	debug( theString );

	if ( !gSilentInstall )
	{
		if ( !gDetonatorWindowOK )
			updateStatusText( theString, 4, 1 );
	}
}


function statusDone( thePage, statusString )
{
	if ( !gSilentInstall )
	{
		if ( thePage != "" ) 
		{
			if ( gDetonatorWindowOK )
			{
				statusNewPage( thePage, statusString );
			}
		}

		if ( gBuiltInWindow != null )
			gBuiltInWindow.close();
	}
}


function statusError( errorString )
{
	if ( !gSilentInstall )
	{
		if ( !gDetonatorWindowOK )
		{
			updateStatusText( "error detected: " + errorString, 4, 2 );
		}
	}
}




// ================ FILE ARRAY STUFF ================


function fileInfoObject( registryName, source, version, targetSubFolder )
{
	this.registryName			= registryName;
	this.version				= version;
	this.sourceFile				= source;
	this.destinationFileName	= targetSubFolder;
}


function makeFileArray( totalElements )
{
	var newArray = null;

	if ( totalElements > 0 )
	{
		newArray = new Array( totalElements );
		for ( i = 0; i < totalElements; i++ )
			newArray[ i ] = new fileInfoObject;
	}

	return newArray;
}


function packFileArray( arrayIndex, fileList, regKey, componentVersion, theSubFolder )
{
	var listItems = count( fileList );
	if ( listItems > 0 )
	{
		var theFileName;

		for ( var i = 1; i <= listItems; i++ )
		{
			theFileName = getAt( fileList, i );

			gFileArray[ arrayIndex ].registryName			= regKey;
			gFileArray[ arrayIndex ].version				= componentVersion;
			gFileArray[ arrayIndex ].sourceFile				= theFileName;
			gFileArray[ arrayIndex ].destinationFileName	= theSubFolder + theFileName;

			arrayIndex++;
		}
	}

	return arrayIndex;
}




// ================ MISCELLANEOUS STUFF ================


function versionStringToObject( s )
{
	var newVersionInfoObject = null;

	if ( count( s ) == 4 )
	{
		var major		= parseInt( getAt( s, 1 ));
		var minor		= parseInt( getAt( s, 2 ));
		var revision	= parseInt( getAt( s, 3 ));
		var build		= parseInt( getAt( s, 4 ));

		newVersionInfoObject = new netscape.softupdate.VersionInfo( major, minor, revision, build );
	}
	
	return newVersionInfoObject;
}


function getFileCount( whichPlugin )
{
	var fileCount = 0;

	if ( whichPlugin == "Flash" )
	{
		fileCount =		count( gFlashPluginFiles				);
		fileCount +=	count( gFlashShockwaveFolderFiles		);
		fileCount +=	count( gFlashXtrasFolderFiles			);
	}
	else if ( whichPlugin == "Director" )
	{
		fileCount =		count( gDirectorPluginFiles				);
		fileCount +=	count( gDirectorShockwaveFolderFiles	);
		fileCount +=	count( gDirectorXtrasFolderFiles		);
	}

	return fileCount;
}


function errorString( errNum )
{
	switch ( errNum )
	{
		case   -1 : return "problem adding components to the install.";
		case   -2 : return "install not approved.";
		case  -20 : return "trying to set up files.";
		case -200 : return "incorrect / bad install package name.";
		case -201 : return "unknown, unexpected error has occurred.";
		case -202 : return "access denied.  Cannot write to system.";
		case -203 : return "too many certificates, only 1 is allowed.";
		case -204 : return "no installer certificate found.";
		case -205 : return "extracted file is not signed.";
		case -206 : return "extracted file does not match installer certificate.";
		case -207 : return "JAR file hasn't been opened/found.";
		case -208 : return "improper function call (bad arguments).";
		case -209 : return "illegal relative path to target.";
		case -210 : return "install cancelled.";
		case -211 : return "install never started.";
		default   : return "an install error has occurred.";
	}

	return null;
}




// ================ INSTALLER GUTS ================


function checkPluginRegistry( regKey )
{
	// check to see if a package with this registry name has been installed previously

	var registry_vi = netscape.softupdate.Trigger.GetVersionInfo( regKey );

	if ( registry_vi == null ) 
	{
		debug( "No registry entry exists for: " + regKey );
	}
	else
	{
		debug( "There is already a registry entry for: " + regKey );
	}

	return 0;
}


function populateFileArray( whichPlugin, regKey, version )
{
	var n = 0;

	if ( whichPlugin == "Director" )
	{
		var folderName = gDirectorShockwaveFolderName;

		n = packFileArray( n, gDirectorPluginFiles,				regKey, version, ""						);
		n = packFileArray( n, gDirectorShockwaveFolderFiles,	regKey, version, folderName				);
		n = packFileArray( n, gDirectorXtrasFolderFiles,		regKey, version, folderName + "Xtras/"	);
	}

	if ( whichPlugin == "Flash" )
	{
		var folderName = gFlashShockwaveFolderName;

		n = packFileArray( n, gFlashPluginFiles,				regKey, version, ""						);
		n = packFileArray( n, gFlashShockwaveFolderFiles,		regKey, version, folderName				);
		n = packFileArray( n, gFlashXtrasFolderFiles,			regKey, version, folderName + "Xtras/"	);
	}

	return 0;
}


function unpackFiles()
{
	var err			= 0;
	var errorString	= "";
	var totalFiles = gFileArray.length;
	var tempFileName;

	for ( var i = 0; i < totalFiles; i++ )
	{
		tempFileName = "file " + ( i+1 ) + " (" + gFileArray[ i ].destinationFileName + ")"
		statusUpdate( "unpacking " + tempFileName + "..." );
		errorString = "problem unpacking " + tempFileName;

		debug( tempFileName + ":" );
//		debug( "     registryName   = " + gFileArray[ i ].registryName			);
//		debug( "     version        = " + gFileArray[ i ].version				);
		debug( "     source         = " + gFileArray[ i ].sourceFile			);
		debug( "     targetFileName = " + gFileArray[ i ].destinationFileName	);

		err = gSU.AddSubcomponent(
				gFileArray[ i ].registryName,
				gFileArray[ i ].version,
				gFileArray[ i ].sourceFile,
				gPluginsFolder,
				gFileArray[ i ].destinationFileName,
				this.force );

		if ( err != 0 )
		{
			statusError( errorString );
			return err;
		}
	}

	return err;
}


function performInstall( whichPlugin )
{
	if ( whichPlugin == "Flash" )
	{
		var regKey		= gFlashRegistryName;
		var versionInfo	= versionStringToObject( gFlashVersionString );
	}
	else if ( whichPlugin == "Director" )
	{
		var regKey		= gDirectorRegistryName;
		var versionInfo	= versionStringToObject( gDirectorVersionString );
	}

	var totalFiles	= getFileCount( whichPlugin );
	gFileArray		= makeFileArray( totalFiles );


	gPluginsFolder = gSU.GetFolder( "Plugins" );
	var plug = "Shockwave " + whichPlugin;
	var err = 0;

	for ( var i = 1; i < 6; i++ )
	{
		switch ( i )
		{
			case 1:
				statusUpdate( "Checking for a previous installation of " + plug + "." );
				err = checkPluginRegistry( regKey );
				break;

			case 2:
				statusUpdate( "Determining which " + plug + " files are appropriate for your computer." );
				err = populateFileArray( whichPlugin, regKey, versionInfo );
				break;

			case 3:
				statusUpdate( "Requesting permission to unpack the files." );
				err = gSU.StartInstall( regKey, versionInfo, 1 );
				break;

			case 4:
				statusUpdate( "Unpacking the " + plug + " components to a temporary folder." );
				err = unpackFiles();
				break;

			case 5:
				statusUpdate( "Requesting permission to install " + plug + "." );
				err = gSU.FinalizeInstall();
		}

		if ( err != 0 )
		{
			statusError( errorString( err ) );
			gSU.AbortInstall() ;
			return err;
		}
	}

	return err;
}




// ================ PREFLIGHT CHECKS ================

function badPrefsAlert( whichPref )
{
	var theString = "This installer requires " + whichPref + ".  ";
	theString += 'Please choose "Enable ' + whichPref + '" from the Advanced preferences and try again.';

	alert( theString );
}


function JavaEnabled()
{
	var javaOK = false;

	javaOK = navigator.javaEnabled();
	if ( javaOK == false )  
		badPrefsAlert( "Java" );

	return javaOK;
}


function smartUpdateEnabled()
{
	var smartUpdateOK = false;

	smartUpdateOK = netscape.softupdate.Trigger.UpdateEnabled();

	if ( smartUpdateOK == false )
		badPrefsAlert( "AutoInstall" );

	return smartUpdateOK;
}




// ===== MAIN PROGRAM EXECUTION STARTS HERE =====

if ( JavaEnabled() && smartUpdateEnabled() )
{

	if ( !gSilentInstall )
	{
		var gDetonatorWindowOK = true;
		var gBuiltInWindow;
		
		var gStatusDonePage			= "";
		var gStatusErrorPage		= "";
		var gSuccessMsg				= "Installation complete.";

		var gDetonatorWindow = getStatusWindow();
		if ( gDetonatorWindow != null )
		{
			gStatusDonePage			= gDetonatorWindow.jarData( "done page"			);
			gStatusErrorPage		= gDetonatorWindow.jarData( "error page"		);
		}

		statusUpdate( "starting the installation..." );
	}


	var gPluginsFolder;
	var gFileArray;
	var gErr = -1;

	if ( gFlashInstall )
	{
		var gSU = new netscape.softupdate.SoftwareUpdate( this, "the Shockwave Flash plug-in" );

		if ( gSU != null )
		{
			gErr = performInstall( "Flash" );
		}
		else
		{
			statusError( "failed to create new softupdate object." );
		}
	}

	if ( gDirectorInstall )
	{
		var gSU = new netscape.softupdate.SoftwareUpdate( this, "the Shockwave Director plug-in" );

		if ( gSU != null )
		{
			if ( gUserOS == "MacPPC" || ( gUserOS == "Mac68K" ))
			{
				// queue the ShockInstall application, which increases Macintosh Navigator's
				// memory partition if necessary:

				err = gSU.Execute( "ShockInstall" );
			}

			gErr = performInstall( "Director" );
		}
		else
		{
			statusError( "failed to create new softupdate object." );
		}
	}


	if (( gSU != null ) && ( gErr == 0 ))
	{
		// make the newly-installed plug-ins immediately useful:
		statusUpdate( "Refreshing and restarting plugins..." );
		navigator.plugins.refresh( true );
	}


	if ( !gSilentInstall )
	{
		if ( gErr == 0 )
		{
			statusDone( gStatusDonePage, gSuccessMsg );
		}
		else
		{
			statusDone( gStatusErrorPage, "" );
		}
	}
}
