#!/bin/sh
#			Build all WWW Code for this platform
#
# (c) COPYRIGHT MIT 1995.
# Please first read the full copyright statement in the file COPYRIGH.
#

# When BUILDing a SOCKSified httpd:
# Set this to the location of your ready-built SOCKS library
# setenv SOCKSLIB /xxxx/yyyy/libsocks.a
## Use this setting to enable SOCKS:
# setenv SOCKS_FLAGS -DSOCKS
## ..OR this setting to enable both SOCKS _and_ client access control:
# setenv SOCKS_FLAGS "-DSOCKS -DCLIENT_CONTROL"
## Note that cern_httpd's normal access control can be used instead.

UNAME=""
if [ -s /usr/bin/uname ]; then		UNAME=`/usr/bin/uname`; fi
if [ -s /bin/uname ]; then 		UNAME=`/bin/uname`; fi
if [ -s /usr/apollo/bin ]; then 	UNAME=`ver sys5.3 /bin/uname`; fi
if [ -s /usr/bin/ncrm ]; then 		UNAME=ncr; fi
if [ -s /usr/bin/swconfig ]; then 	UNAME=sco; fi
if [ -s /usr/lib/NextStep/software_version ]; then       UNAME=next; fi
#
export UNAME
WWW_MACH=""; export WWW_MACH

if [ "$UNAME" = "next" ]; then		WWW_MACH=next;export WWW_MACH;fi
if [ "$UNAME" = "ncr" ]; then		WWW_MACH=ncr;export WWW_MACH;fi
if [ "$UNAME" = "sco" ]; then
	WWW_MACH=sco;export WWW_MACH;
	PATH=${PATH}:/usr/local/bin;export PATH;
fi
if [ "$UNAME" = "HP-UX" ]; then		WWW_MACH=snake;export WWW_MACH;fi
if [ "$UNAME" = "IRIX" ]; then		WWW_MACH=sgi;export WWW_MACH;fi
if [ "$UNAME" = "SunOS" ]; then
	arch=`arch`
	revision=`uname -r`
	if [ "`echo $revision | cut -d. -f1`" = "5" ]; then
		WWW_MACH=${arch}-sol2;export WWW_MACH
	else
		WWW_MACH=${arch};export WWW_MACH
	fi
fi
if [ "$UNAME" = "ULTRIX" ]; then	WWW_MACH=ultrix;export WWW_MACH;fi
if [ "$UNAME" = "AIX" ]; then		WWW_MACH=aix;export WWW_MACH;fi
if [ "$UNAME" = "OSF1" ]; then		WWW_MACH=osf1;export WWW_MACH;fi
if [ "$UNAME" = "BSD/OS" ]; then	WWW_MACH=unix;export WWW_MACH;fi
if [ "$UNAME" = "Linux" ]; then		WWW_MACH=linux;export WWW_MACH;fi
if [ "$UNAME" = "FreeBSD" ]; then       WWW_MACH=freebsd;export WWW_MACH;fi
if [ "$UNAME" = "NetBSD" ]; then	WWW_MACH=netbsd;export WWW_MACH;fi
if [ "$UNAME" = "A/UX" ]; then		WWW_MACH=apple;export WWW_MACH;fi
if [ "$UNAME" = "SMP_DC.OSx" ]; then	WWW_MACH=pyramid;export WWW_MACH;fi

#
# ISC 3.0 (How can I tell I'm running on ISC 3.0 ???)
#
# set WWW_MACH=isc3.0
# setenv WWW_MACH isc3.0		# Lauren

if [ "$WWW_MACH" = "" ]; then
	echo 
	echo "The environment variable WWW_MACH could not be set to the"
	echo "architecture code for the machine you are working on."
	echo "This is normally due to that the BUILD script could not"
	echo "figure out your platform." 
	echo 
	echo "Please read how to modify the BUILD script in the README file"
	echo 
	echo "If you have problems or want to send back your modifications"
	echo "then please contact <libwww@w3.org>."
	echo 
	echo "Online documentation is available from <URL:http://www.w3.org/>"
	echo 
	exit -1
fi
echo "________________________________________________________________"
echo "WWW build for machine type:                            " $WWW_MACH

#	Now go do build

#	We don't want SHELL set to something funny to screw up make

(cd All/Implementation; unset SHELL; make)
stat=$?
echo
echo "WWW build for " $WWW_MACH  " done. status = " $stat
exit $stat
