// PassDirectory.java
// $Id: PassDirectory.java,v 1.7 1998/04/06 12:24:40 bmahe Exp $
// (c) COPYRIGHT MIT and INRIA, 1996.
// Please first read the full copyright statement in file COPYRIGHT.html

package org.w3c.jigsaw.resources ;

import java.util.*;
import java.io.*;

import org.w3c.tools.resources.*;

public class PassDirectory extends org.w3c.jigsaw.resources.DirectoryResource {

    /**
     * Attribute index - The target physicall directory of this resource.
     */
    protected static int ATTR_PASSTARGET = -1 ;

    static {
	Attribute a   = null ;
	Class     cls = null ;

	// Get a pointer to our class.
	try {
	    cls = Class.forName("org.w3c.jigsaw.resources.PassDirectory") ;
	} catch (Exception ex) {
	    ex.printStackTrace() ;
	    System.exit(1) ;
	}
	// The directory attribute.
	a = new FileAttribute("pass-target"
			      , null
			      , Attribute.EDITABLE);
	ATTR_PASSTARGET = AttributeRegistry.registerAttribute(cls, a) ;
    }

    /**
     * Catch side-effects on pass-target, to absolutize it.
     * @param idx The attribute to set.
     * @param value The new value.
     */

    public void setValue(int idx, Object value) {
	super.setValue(idx, value);
	if ( idx == ATTR_PASSTARGET ) {
	    File file = (File) value;
	    if ( ! file.isAbsolute() ) {
		// Make it absolute, relative to the server space.
		File abs = new File(getServer().getRootDirectory()
				    , file.toString());
		values[ATTR_PASSTARGET] = abs;
		values[ATTR_DIRECTORY]  = abs;
	    }
	}
    }

    /**
     * The getDirectory method now returns the pass-directory.
     * @return The pass target location.
     */

    public File getDirectory() {
	return (File) getValue(ATTR_PASSTARGET, null) ;
    }

    /**
     * Make the directory attribute default to the target location.
     * This is required for classes that rely on the directory attribute to
     * compute their own attributes.
     * @param values The values we should initialized from.
     */

    public void initialize(Object values[]) {
	super.initialize(values);
	File target = getDirectory();
	if ( target != null ) 
	    setValue(ATTR_DIRECTORY, target);
    }


}
