// ProxyProp.java
// $Id: ProxyProp.java,v 1.8 1998/03/09 15:37:18 ylafon Exp $
// (c) COPYRIGHT MIT and INRIA, 1996.
// Please first read the full copyright statement in file COPYRIGHT.html

package org.w3c.jigsaw.proxy;

import java.util.Enumeration;
import org.w3c.tools.resources.*;
import org.w3c.jigsaw.http.*;
import org.w3c.jigsaw.resources.*;
import org.w3c.jigsaw.config.*;

import org.w3c.www.protocol.http.HttpManager;

class ProxyProp extends PropertySet {
    private static String title = "Proxy properties";

    static {
	Class     c = null;
	Attribute a = null;

	try {
	    c = Class.forName("org.w3c.jigsaw.proxy.ProxyProp");
	} catch (Exception ex) {
	    ex.printStackTrace();
	    System.exit(1);
	}
	// Register the maximum number of allowed connections:
	a = new IntegerAttribute(HttpManager.CONN_MAX_P
				 , null
				 , Attribute.EDITABLE);
	AttributeRegistry.registerAttribute(c, a);
	// Register the timeout on the client socket
	a = new IntegerAttribute(HttpManager.TIMEOUT_P
				 , new Integer(300000) // default 5mn
				 , Attribute.EDITABLE);
	AttributeRegistry.registerAttribute(c, a);
        // Register the proxy set property
	a = new BooleanAttribute(HttpManager.PROXY_SET_P
				, null
				, Attribute.EDITABLE);
	AttributeRegistry.registerAttribute(c, a);
	// Register the proxy host:
	a = new StringAttribute(HttpManager.PROXY_HOST_P
				, null
				, Attribute.EDITABLE);
	AttributeRegistry.registerAttribute(c, a);
	// Register the proxy port:
	a = new IntegerAttribute(HttpManager.PROXY_PORT_P
				 , new Integer(80)
				 , Attribute.EDITABLE);
	AttributeRegistry.registerAttribute(c, a);
	// Register the filters property
	a = new StringArrayAttribute(HttpManager.FILTERS_PROP_P
				     , null
				     , Attribute.EDITABLE);
	AttributeRegistry.registerAttribute(c, a);
    }

    /**
     * Get this property set title.
     * @return A String encoded title.
     */

    public String getTitle() {
	return title;
    }

    /**
     * Set value forwards the effectation to the properties.
     * @param idx The attribute (property in that case) being set.
     * @param value The new value for that property.
     */

    public synchronized void setValue(int idx, Object value) {
	// Check access (we don't care about side effects)
	super.setValue(idx, value);
	if ( idx == ATTR_RESOURCE_FRAMES ) {
	    Attribute a = attributes[idx];
	    if (a.getName().equals(HttpManager.FILTERS_PROP_P)) {
		Enumeration e = server.enumeratePropertySet();
		PropertySet p;
		Boolean add;
		String flt[] = (String [])getValue(idx, null);
		// FIXME! shouldget the name of the property set associated
		// to the filter, and verify if it is present or not
		// if not, register the property set
		for(int i=0; i<flt.length; i++) {
		    if(flt[i].equals(
			"org.w3c.www.protocol.http.micp.MICPFilter")){
			p = new 
			    org.w3c.www.protocol.http.micp.MICPProp("micp"
								    , server);
			server.registerPropertySet(p);
		    }
		}
	    }
	}
    }

    ProxyProp(String name, httpd server) {
	super(name, server);
    }
}
