// PutSizeFilter.java
// $Id: PutSizeFilter.java,v 1.11 1998/07/02 09:05:12 ylafon Exp $
// (c) COPYRIGHT MIT and INRIA, 1997.
// Please first read the full copyright statement in file COPYRIGHT.html

package org.w3c.jigsaw.filters;

import java.io.*;

import org.w3c.tools.resources.*;
import org.w3c.www.http.*;
import org.w3c.jigsaw.http.*;
import org.w3c.jigsaw.resources.*;

public class PutSizeFilter extends ResourceFilter {
    /**
     * Attribute index - The maximum size of the put document
     */
    
    protected static int ATTR_PUTSIZE = -1;
    protected static int ATTR_STRICT  = -1;

    static {
	Class     c = null;
	Attribute a = null;

	try {
	    c = Class.forName("org.w3c.jigsaw.filters.PutSizeFilter");
	} catch (Exception ex) {
	    ex.printStackTrace();
	    System.exit(1);
	}
	// Register the PutList URL attribute:
	a = new IntegerAttribute("put-size"
				 , new Integer(65536)
				 , Attribute.EDITABLE|Attribute.MANDATORY);
	ATTR_PUTSIZE = AttributeRegistry.registerAttribute(c, a);
	a = new BooleanAttribute("strict"
				 , new Boolean(true)
				 , Attribute.EDITABLE|Attribute.MANDATORY);
	ATTR_STRICT = AttributeRegistry.registerAttribute(c, a);
    }

    private Reply notifyFailure(Request request, boolean no_size) {
	Reply er = null;
	if (request.getExpect() != null)
	    er = request.makeReply(HTTP.EXPECTATION_FAILED);
	else {
	    if (no_size)
		er = request.makeReply(HTTP.LENGTH_REQUIRED);
	    else
		er = request.makeReply(HTTP.REQUEST_ENTITY_TOO_LARGE);
	}
	er.setContent("<P>You are not allowed to PUT documents more than " +
		      getInt(ATTR_PUTSIZE, -1) + " bytes long</P>");
	return er;
    }

    public ReplyInterface ingoingFilter(RequestInterface req) {
	Request request = (Request) req;
	if(request.getMethod().equals("PUT")) {
	    if(getBoolean(ATTR_STRICT, true) && !request.hasContentLength()) 
		return notifyFailure(request, true);
	    if(request.getContentLength() > getInt(ATTR_PUTSIZE, -1))
		return notifyFailure(request, false);
	}
	return null;
    }
     
    public ReplyInterface outgoingFilter(RequestInterface req, 
					 ReplyInterface rep) {
	return null;
    }
}
