// AuthRealm.java
// $Id: AuthRealm.java,v 1.10 1998/02/03 12:55:55 bmahe Exp $
// (c) COPYRIGHT MIT and INRIA, 1996.
// Please first read the full copyright statement in file COPYRIGHT.html

package org.w3c.jigsaw.auth;

import java.io.*;
import java.util.*;

import org.w3c.tools.resources.*;

public class AuthRealm extends ExternalContainer {

  /**
   * Load the user having this name.
   * @param name The user's name.
   * @return An instance of AuthUser or <strong>null</strong> if not found.
   */

  public synchronized ResourceReference loadUser(String name) {
    return lookup(name);
  }

  /**
   * register this new user in the realm.
   * @param user  The new user.
   */

  public synchronized void registerUser(AuthUser user) {
    addResource(user, null);
  }

  public void registerResource(String name,
			       Resource resource,
			       Hashtable defs) 
  {
    if( resource instanceof AuthUser) {
      registerUser(AuthUser.makeUser(name, new ResourceContext(getContext())));
    }
  }

  /**
   * Unregister a user from the realm.
   * @param name The user's name.
   */

  public synchronized void unregisterUser(String name) 
    throws MultipleLockException
  {
    delete(name);
  }

  /**
   * Enumerate this realm user's name.
   */

  public synchronized Enumeration enumerateUserNames() {
    return enumerateResourceIdentifiers();
  }

  /**
   * create a new empty realm.
   * @param name The name of the realm.
   * @param repository The file to use to store the realm database.
   */
  public static AuthRealm makeRealm(ResourceContext context, String name) {
    Hashtable defs = new Hashtable(3) ;
    defs.put("identifier", name) ;
    defs.put("context", context);
    AuthRealm realm = new AuthRealm(name, context) ;
    realm.initialize(defs) ;
    return realm ;
  }

  /**
   * Save our store.
   */

  public synchronized void save() {

  }

  public File getRepository(ResourceContext context) {
    return new File(context.getServer().getAuthDirectory(),
		    getIdentifier()+".db");
  }

  public AuthRealm(String id, ResourceContext context)  {
    super(id, context, false);
  }

  public AuthRealm() {
    super() ;
  }

}
