/*
 *  SymbolToBoolean.java
 *
 *  Copyright 1997 Massachusetts Institute of Technology.
 *  All Rights Reserved.
 *
 *  Author: Ora Lassila
 *
 *  $Id: SymbolToBoolean.java,v 1.2 1998/01/22 14:33:57 bmahe Exp $
 */

package org.w3c.www.pics;

public class SymbolToBoolean implements Mapper {

  public Object map(Object value) throws PICSParserException
  {
    if (value == PICS.TRUE)
      return Boolean.TRUE;
    else if (value == PICS.FALSE)
      return Boolean.FALSE;
    else
      throw new PICSParserException("Illegal boolean value " + value);
  }

}
