// DebugFilter.java
// $Id: DebugFilter.java,v 1.9 1998/03/30 09:15:06 bmahe Exp $
// (c) COPYRIGHT MIT and INRIA, 1996.
// Please first read the full copyright statement in file COPYRIGHT.html

package org.w3c.jigsaw.filters;

import java.io.*;

import org.w3c.tools.resources.*;
import org.w3c.jigsaw.http.*;
import org.w3c.jigsaw.resources.*;

/**
 * Print incoming request and outgoing replies.
 */


public class DebugFilter extends ResourceFilter {
    /**
     * Attribute index - The on/off toggle.
     */
    protected static int ATTR_ONOFF = -1 ;

    static {
	Attribute a   = null ;
	Class     cls = null ;
	try {
	    cls = Class.forName("org.w3c.jigsaw.filters.DebugFilter");
	} catch (Exception ex) {
	    ex.printStackTrace() ;
	    System.exit(1) ;
	}
	// The onoff toggle
	a = new BooleanAttribute("onoff"
				 , Boolean.TRUE
				 , Attribute.EDITABLE) ;
	ATTR_ONOFF = AttributeRegistry.registerAttribute(cls, a) ;
    }

    /**
     * Get the onoff toggle value.
     */

    public boolean getOnOffFlag() {
	return getBoolean(ATTR_ONOFF, true) ;
    }

    /**
     * The ingoing filter - fearly easy !
     * @param request The incomming request.
     * @return Always <strong>null</strong>.
     */

    public ReplyInterface ingoingFilter(RequestInterface req) {
	Request request = (Request) req;
	if ( getOnOffFlag() ) 
	    request.dump(System.out);
	return null;
    }

    /**
     * The outgoing filter - As easy as the ingoing filter.
     * @param request The original request.
     * @param reply The target's reply.
     * @exception HTTPException If processing failed.
     */

    public ReplyInterface outgoingFilter(RequestInterface req,
					 ReplyInterface rep) 
    {
	Reply reply = (Reply) rep;
	if ( getOnOffFlag() ) 
	    reply.dump(System.out);
	return null ;
    }

}

