// CvsDirectoryHandler.java
// $Id: CvsDirectoryHandler.java,v 1.3 1998/04/07 09:59:28 bmahe Exp $
// (c) COPYRIGHT MIT and INRIA, 1996.
// Please first read the full copyright statement in file COPYRIGHT.html

//
// FIXME add extra environment parameter to all public methods
// witch run cvs.
//

package org.w3c.jigsaw.cvs ;

import org.w3c.cvs.* ;
import org.w3c.www.http.*;
import org.w3c.jigsaw.http.* ;
import org.w3c.jigsaw.auth.AuthFilter;
import org.w3c.tools.resources.* ;
import org.w3c.jigsaw.html.HtmlGenerator ;

public class CvsDirectoryHandler implements CvsHandlerInterface {
    CvsDirectory cvs = null ;

  
    /**
     * Perform the action on the given entity.
     * @param request The request that triggered this method call.
     * @param action The action to perform.
     * @param names Name of files to apply the action to.
     * @exception HTTPException If running the action failed.
     */

    public void perform (Request request, String action, 
			 String names[], String revs[])
	throws ProtocolException
    {
	try {
	    if ( action.equals ("add") ) {
		String u = (String)request.getState(AuthFilter.STATE_AUTHUSER);
		String env[] = {"USER="+u , "LOGNAME="+u };
		cvs.add (names, env) ;
	    } else if ( action.equals ("revert") ) {
		String u = (String)request.getState(AuthFilter.STATE_AUTHUSER);
		String env[] = {"USER="+u , "LOGNAME="+u };
		String msg = ((u != null)
			      ? "("+u+") changed through Jigsaw, no comments"
			      : "changed through Jigsaw, no comments");
		for (int i=0; i<names.length; i++)
		    cvs.revert(names[i], revs[i], msg, env);
	    } else if ( action.equals ("remove") ) {
		String u = (String)request.getState(AuthFilter.STATE_AUTHUSER);
		String env[] = {"USER="+u , "LOGNAME="+u };
		cvs.remove(names, 
			   ((u != null)
			    ? "("+u+") changed through Jigsaw, no comments"
			    : "changed through Jigsaw, no comments"),
			   env);
	    } else if ( action.equals ("update") ) {
		cvs.update(names) ;
	    } else if ( action.equals("commit") ) {
		String u = (String)request.getState(AuthFilter.STATE_AUTHUSER);
		String env[] = {"USER="+u , "LOGNAME="+u };
		cvs.commit(names
			   , ((u != null)
			      ? "("+u+") changed through Jigsaw, no comments"
			      : "changed through Jigsaw, no comments"),
			   env);
	    } else {
		Reply error = request.makeReply(HTTP.BAD_REQUEST) ;
		HtmlGenerator g = new HtmlGenerator ("Bad CVS command") ;
		g.append ("<p>Your command "
			  + "<strong>"+ action + "</strong>"
			  + " wasn't undesrtood."
			  + "<hr>" + this.getClass().getName()) ;
		error.setStream (g) ;
		throw new HTTPException (error) ;
	    }
	} catch (CvsException ex) {
	    String msg = action+" in "+cvs.getDirectory()+" failed";
	    throw new HTTPException(CvsFrame.error(request, msg, ex));
	}
    }

    /**
     * Perform the action on the given entity.
     * @param action The action to perform.
     * @param names The names on which the action should be performed.
     * @param comment A string of comments describing the change.
     * @exception HTTPException If running the action failed.
     */

    public void perform (Request request, 
			 String action, 
			 String names[],
			 String revs[],
			 String comment) 
	throws ProtocolException
    {
	for(int i = 0 ; i < names.length ; i++)
	    System.out.println("*** perform "+action+" on "+names[i]);
	try {
	    if ( action.equals ("add") ) {
		String u = (String)request.getState(AuthFilter.STATE_AUTHUSER);
		String env[] = {"USER="+u , "LOGNAME="+u };
		cvs.add(names, env) ;
	    } else if ( action.equals ("revert") ) {
		String u = (String)request.getState(AuthFilter.STATE_AUTHUSER);
		String env[] = {"USER="+u , "LOGNAME="+u };
		String msg = ((u!=null) ? "("+u+") "+comment : comment);
		for (int i=0; i<names.length; i++)
		    cvs.revert(names[i], revs[i], msg, env);
	    } else if ( action.equals ("remove") ) {
		String u = (String)request.getState(AuthFilter.STATE_AUTHUSER);
		String env[] = {"USER="+u , "LOGNAME="+u };
		cvs.remove(names,
			   ((u!=null) ? "("+u+") "+comment : comment),
			   env);
	    } else if ( action.equals("update") ) {
		cvs.update(names) ;
	    } else if ( action.equals ("commit") ) {
		String u = (String)request.getState(AuthFilter.STATE_AUTHUSER);
		String env[] = {"USER="+u , "LOGNAME="+u };
		cvs.commit(names, 
			   ((u!=null) ? "("+u+") "+comment : comment),
			   env);
	    } else {
		Reply error = request.makeReply(HTTP.BAD_REQUEST) ;
		HtmlGenerator g = new HtmlGenerator ("Bad CVS command") ;
		g.append ("<p>Your command "
			  + "<strong>"+ action + "</strong>"
			  + " wasn't undesrtood."
			  + "<hr>" + this.getClass().getName()) ;
		error.setStream (g) ;
		throw new HTTPException (error) ;
	    }
	} catch (CvsException ex) {
	    String msg = action+" in "+cvs.getDirectory()+" failed";
	    throw new HTTPException(CvsFrame.error(request, msg, ex));
	}
    }

    CvsDirectoryHandler(CvsDirectory cvs) {
	super() ;
	this.cvs = cvs ;
    }

}
