// CacheProp.java
// $Id: CacheProp.java,v 1.9 1997/03/12 10:51:19 abaird Exp $
// (c) COPYRIGHT MIT and INRIA, 1996.
// Please first read the full copyright statement in file COPYRIGHT.html

package w3c.jigsaw.proxy;

import w3c.tools.store.*;
import w3c.jigsaw.http.*;
import w3c.jigsaw.resources.*;
import w3c.jigsaw.config.*;

import w3c.www.protocol.http.HttpManager;
import w3c.www.protocol.http.cache.CacheFilter;

class CacheProp extends PropertySet {
    private static String title = "Cache properties";

    static {
	Class     c = null;
	Attribute a = null;

	try {
	    c = Class.forName("w3c.jigsaw.proxy.CacheProp");
	} catch (Exception ex) {
	    ex.printStackTrace();
	    System.exit(1);
	}
	// The cache size in bytes:
	a = new IntegerAttribute(CacheFilter.CACHE_SIZE_P
				 , new Integer(5000000)
				 , Attribute.EDITABLE);
	AttributeRegistry.registerAttribute(c, a);
	// The debug flag:
	a = new BooleanAttribute(CacheFilter.DEBUG_P
				 , Boolean.FALSE
				 , Attribute.EDITABLE);
	AttributeRegistry.registerAttribute(c, a);
	// The is-shared flag:
	a = new BooleanAttribute(CacheFilter.SHARED_P
				 , Boolean.TRUE
				 , Attribute.EDITABLE);
	AttributeRegistry.registerAttribute(c, a);
	// Is the cache to be connected ?
	a = new BooleanAttribute(CacheFilter.CACHE_CONNECTED_P
				 , Boolean.TRUE
				 , Attribute.EDITABLE);
       AttributeRegistry.registerAttribute(c, a);
       // Are garbage collections allowed ?
       a = new BooleanAttribute(CacheFilter.GARBAGE_COLLECTION_ENABLED_P
				, Boolean.TRUE
				, Attribute.EDITABLE);
       AttributeRegistry.registerAttribute(c, a);
       // The allowed file size ratio:
       a = new DoubleAttribute(CacheFilter.FILE_SIZE_RATIO_P
			       , new Double((double) 0.1)
			       , Attribute.EDITABLE);
       AttributeRegistry.registerAttribute(c, a);
    }
			       
    /**
     * Get this property set title.
     * @return A String encoded title.
     */

    public String getTitle() {
	return title;
    }

    CacheProp(String name, httpd server) {
	super(name, server);
    }
}
