// MapAttribute.java
// $Id: MapAttribute.java,v 1.8 1997/01/17 09:55:13 abaird Exp $
// (c) COPYRIGHT MIT and INRIA, 1996.
// Please first read the full copyright statement in file COPYRIGHT.html

package w3c.jigsaw.map ;

import java.io.*;
import java.io.IOException;

import w3c.tools.store.*;
import w3c.util.* ;

class MapAttribute extends Attribute {
    private static final byte VALID_MAP = 1;
    private static final byte INVALID_MAP = 0;

    public boolean checkValue(Object obj)
    {
	return (obj == null || obj instanceof Map);
    }

    /**
     * Get the number of bytes required to save that attribute value.
     * @param The value about to be pickled.
     * @return The number of bytes needed to pickle that value.
     */

    public final int getPickleLength(Object value) {
	CountOutputStream out  = new CountOutputStream();
	DataOutputStream  dout = new DataOutputStream(out);
	Map               map  = (Map) value;
	try {
	    map.pickle(dout);
	    dout.close();
	    return out.getCount();
	} catch (IOException ex) {
	    throw new RuntimeException("IO erred in CountOutputStream.");
	}
    }


    public void pickle(DataOutputStream out, Object obj)
	throws IOException
    {
	if(obj == null)
	    out.writeByte(INVALID_MAP);
	else {
	    out.writeByte(VALID_MAP);
	    ( (Map) obj ).pickle(out);
	}
    }

    public Object unpickle(DataInputStream in)
	throws IOException 
    {
	byte valid = in.readByte();
	if(valid == VALID_MAP) {
	    Map map = new Map();
	    map.unpickle(in);
	    return map;
	} else return null;
    }

    public MapAttribute(String name, Map def, int flags) 
    {
	super(name,def,flags);
	this.type = "w3c.jigsaw.map.Map";
    }
}

