// GhostResourceIndexer.java
// $Id: GhostResourceIndexer.java,v 1.1 1997/09/04 11:27:45 bmahe Exp $  
// (c) COPYRIGHT MIT and INRIA, 1997.
// Please first read the full copyright statement in file COPYRIGHT.html

package w3c.jigsaw.indexer;

import java.util.*;
import java.io.*;

import w3c.tools.store.*;
import w3c.jigsaw.resources.*;


public class GhostResourceIndexer extends SampleResourceIndexer {
  
  /**
   * Try to create a resource for the given file.
   * This method makes its best efforts to try to build a default
   * resource out of a file. 
   * @param directory The directory the file is in.
   * @param name The name of the file.
   * @param defs Any default attribute values that should be provided
   *    to the created resource at initialization time.
   * @return A Resource instance, or <strong>null</strong> if the given
   *    file can't be truned into a resource given our configuration
   *    database.
   */

  public HTTPResource createResource(ContainerResource container
				     , w3c.jigsaw.http.Request request
				     , File directory
				     , String name
				     , Hashtable defs) {
    File file = new File(directory, name) ;
    // Okay, dispatch on wether it is a file or a directory.
    HTTPResource result = null;
    if ( file.isDirectory() )
      result = createDirectoryResource(directory, name, defs) ;
    else
      result = createFileResource(directory, name, defs) ;
    if ( result != null )
      return result;
    // Try the super indexer if available:
    String superIndexer = getSuperIndexer();
    if ( superIndexer == null )
      return null;
    IndexerModule m = null;
    m = (IndexerModule) getContext().getModule(IndexerModule.NAME);
    ResourceIndexer p = m.getIndexer(superIndexer);
    return ((p != null) 
	    ? p.createResource(container, request, directory, name, defs)
	    : null);
  }

}
