/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.jigadmin.gui;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.UIManager;
import org.w3c.jigadmin.PropertyManager;
import org.w3c.jigadmin.RemoteResourceWrapper;
import org.w3c.jigadmin.editors.FramedResourceHelper;
import org.w3c.jigadmin.editors.ServerEditorFactory;
import org.w3c.jigadmin.editors.ServerEditorInterface;
import org.w3c.jigadmin.gui.AuthPanel;
import org.w3c.jigadmin.gui.Message;
import org.w3c.jigadmin.gui.ServerMenu;
import org.w3c.jigadmin.gui.WindowCloser;
import org.w3c.jigadmin.gui.slist.ServerList;
import org.w3c.jigadmin.gui.slist.ServerListListener;
import org.w3c.jigadmin.widgets.DnDJPanel;
import org.w3c.jigadmin.widgets.Icons;
import org.w3c.jigsaw.admin.AdminContext;
import org.w3c.jigsaw.admin.RemoteAccessException;
import org.w3c.jigsaw.admin.RemoteResource;

public class ServerBrowser
extends JPanel
implements ServerListListener {
    protected JFrame frame = null;
    protected JDialog popup = null;
    protected JPanel serverPanel = null;
    protected ServerList serverList = null;
    private AdminContext admin = null;
    RemoteResourceWrapper rootResource = null;

    protected ServerBrowser(JFrame jFrame) {
        this.frame = jFrame;
        jFrame.addWindowListener(new WindowCloser());
        jFrame.setJMenuBar(this.getMenuBar());
        ((Component)jFrame).setSize(800, 600);
    }

    public ServerBrowser(JFrame jFrame, AdminContext adminContext) {
        this.frame = jFrame;
        this.admin = adminContext;
        jFrame.addWindowListener(new WindowCloser());
        jFrame.setJMenuBar(this.getMenuBar());
        ((Component)jFrame).setSize(800, 600);
        this.initialize();
        this.build();
    }

    protected void build() {
        Object object;
        this.serverPanel = new DnDJPanel(new CardLayout());
        this.serverPanel.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 0));
        this.serverList = this.getServerList();
        if (this.serverList == null) {
            return;
        }
        this.serverList.addServerListListener(this);
        String[] stringArray = this.serverList.getModel().getServers();
        int n = 0;
        while (n < stringArray.length) {
            object = stringArray[n];
            RemoteResourceWrapper remoteResourceWrapper = this.serverList.getModel().getServer((String)object);
            ServerEditorInterface serverEditorInterface = ServerEditorFactory.getServerEditor((String)object, this, remoteResourceWrapper);
            this.serverPanel.add((String)object, serverEditorInterface.getComponent());
            ++n;
        }
        object = new JPanel(new BorderLayout());
        ((Container)object).add((Component)this.serverList, "North");
        ((JComponent)object).setBorder(BorderFactory.createEmptyBorder(1, 0, 0, 0));
        this.setLayout(new BorderLayout());
        this.add((Component)object, "West");
        this.add((Component)this.serverPanel, "Center");
        this.setBorder(BorderFactory.createLoweredBevelBorder());
    }

    protected void dispose(boolean bl) {
        if (!bl) {
            WindowCloser.close(this.frame);
            this.popup.dispose();
            this.popup = null;
        } else if (this.popup != null) {
            this.popup.dispose();
            this.popup = null;
        }
    }

    protected AdminContext getAdminContext() {
        return this.admin;
    }

    public JFrame getFrame() {
        return this.frame;
    }

    public JMenuBar getMenuBar() {
        return new ServerMenu(this);
    }

    public RemoteResourceWrapper getRootWrapper() {
        return this.rootResource;
    }

    protected ServerList getServerList() {
        boolean bl = false;
        ServerList serverList = null;
        while (!bl) {
            Object var4_3;
            try {
                try {
                    bl = true;
                    serverList = new ServerList(this.getRootWrapper(), Icons.serverIcon);
                }
                catch (RemoteAccessException remoteAccessException) {
                    if (remoteAccessException.getMessage().equals("Unauthorized")) {
                        bl = false;
                    }
                    Message.showErrorMessage((Component)this, remoteAccessException);
                }
                var4_3 = null;
                if (bl) continue;
                this.popupPasswdDialog("admin");
            }
            catch (Throwable throwable) {
                var4_3 = null;
                if (!bl) {
                    this.popupPasswdDialog("admin");
                }
                throw throwable;
            }
        }
        return serverList;
    }

    protected void initialize() {
        boolean bl = false;
        RemoteResource remoteResource = null;
        while (!bl) {
            Object var4_3;
            try {
                try {
                    bl = true;
                    this.admin.initialize();
                }
                catch (RemoteAccessException remoteAccessException) {
                    if (remoteAccessException.getMessage().equals("Unauthorized")) {
                        bl = false;
                    }
                    Message.showErrorMessage((Component)this, remoteAccessException);
                }
                var4_3 = null;
                if (bl) continue;
                this.popupPasswdDialog("admin");
            }
            catch (Throwable throwable) {
                var4_3 = null;
                if (!bl) {
                    this.popupPasswdDialog("admin");
                }
                throw throwable;
            }
        }
        try {
            remoteResource = this.admin.getAdminResource();
        }
        catch (RemoteAccessException remoteAccessException) {
            remoteAccessException.printStackTrace();
            System.exit(0);
        }
        this.rootResource = new RemoteResourceWrapper(remoteResource, this);
    }

    public static void main(String[] stringArray) {
        Properties properties;
        String string = null;
        String string2 = null;
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].equals("-root")) {
                properties = System.getProperties();
                string2 = stringArray[++n];
                ((Hashtable)properties).put(PropertyManager.ROOT_P, string2);
                System.setProperties(properties);
            } else {
                string = stringArray[n];
            }
            ++n;
        }
        if (string == null) {
            string = "http://localhost:8009/";
        }
        ServerBrowser.unBoldSpecificFonts();
        try {
            properties = new AdminContext(new URL(string));
            JFrame jFrame = new JFrame("Server Browser: " + string);
            ServerBrowser serverBrowser = new ServerBrowser(jFrame, (AdminContext)properties);
            jFrame.getContentPane().add((Component)serverBrowser, "Center");
            ((Component)jFrame).setVisible(true);
        }
        catch (MalformedURLException malformedURLException) {
            System.err.println("Invalid URL : " + string);
        }
        catch (RemoteAccessException remoteAccessException) {
            remoteAccessException.printStackTrace();
        }
    }

    protected void open(URL uRL) {
        class Org_w3c_jigadmin_gui_ServerBrowser$1 {
            /* synthetic */ Org_w3c_jigadmin_gui_ServerBrowser$1() {
            }
        }
        new Openner(null, uRL).start();
    }

    public void popupPasswdDialog(String string) {
        if (this.popup == null) {
            AuthPanel authPanel = new AuthPanel(this, string);
            this.popup = new JDialog(this.frame, "Authorization for JigAdmin", false);
            Container container = this.popup.getContentPane();
            container.setLayout(new GridLayout(1, 1));
            container.add(authPanel);
            ((Component)this.popup).setSize(new Dimension(300, 220));
            this.popup.show();
            authPanel.getFocus();
            while (!authPanel.waitForCompletion()) {
            }
        }
    }

    public void popupResource(RemoteResourceWrapper remoteResourceWrapper) {
        try {
            this.setCursor(3);
            JDialog jDialog = new JDialog(this.frame, "Edit Resource", false);
            FramedResourceHelper framedResourceHelper = new FramedResourceHelper();
            jDialog.setJMenuBar(framedResourceHelper.getMenuBar(jDialog));
            PropertyManager propertyManager = PropertyManager.getPropertyManager();
            Properties properties = propertyManager.getEditorProperties(remoteResourceWrapper);
            framedResourceHelper.initialize(remoteResourceWrapper, properties);
            Container container = jDialog.getContentPane();
            container.setLayout(new GridLayout(1, 1));
            container.add(framedResourceHelper.getComponent());
            ((Component)jDialog).setSize(new Dimension(500, 550));
            jDialog.setLocationRelativeTo(this);
            jDialog.show();
            this.setCursor(0);
        }
        catch (RemoteAccessException remoteAccessException) {
            Message.showErrorMessage((Component)this, remoteAccessException);
        }
    }

    public void serverSelected(String string, RemoteResourceWrapper remoteResourceWrapper) {
        this.setCursor(3);
        ((CardLayout)this.serverPanel.getLayout()).show(this.serverPanel, string);
        ServerEditorFactory.updateServerEditor(string, this, remoteResourceWrapper);
        this.setCursor(0);
    }

    protected void setAdminURL(URL uRL) {
        try {
            this.setCursor(3);
            this.frame.invalidate();
            this.removeAll();
            this.admin = new AdminContext(uRL);
            this.initialize();
            this.build();
            RemoteResourceWrapper remoteResourceWrapper = this.serverList.getModel().getServer("Admin");
            this.serverSelected("Admin", remoteResourceWrapper);
            this.frame.validate();
            this.setCursor(0);
            this.frame.setTitle("Server Browser : " + uRL);
        }
        catch (RemoteAccessException remoteAccessException) {
            JOptionPane.showMessageDialog(this, remoteAccessException.getMessage(), "RemoteAccessException", 0);
        }
    }

    public void setCursor(int n) {
        ((Component)this.frame).setCursor(Cursor.getPredefinedCursor(n));
    }

    public boolean shouldRetry(RemoteAccessException remoteAccessException) {
        if (remoteAccessException.getMessage().equals("Unauthorized")) {
            this.popupPasswdDialog("admin");
            return true;
        }
        Message.showErrorMessage((Component)this, remoteAccessException);
        return false;
    }

    public static void unBoldSpecificFonts() {
        Font font = new Font("Dialog", 0, 12);
        UIManager.put("Button.font", font);
        UIManager.put("CheckBox.font", font);
        UIManager.put("CheckBoxMenuItem.font", font);
        UIManager.put("ComboBox.font", font);
        UIManager.put("DesktopIcon.font", font);
        UIManager.put("InternalFrame.font", font);
        UIManager.put("InternalFrame.titleFont", font);
        UIManager.put("Label.font", font);
        UIManager.put("Menu.font", font);
        UIManager.put("MenuBar.font", font);
        UIManager.put("MenuItem.font", font);
        UIManager.put("ProgressBar.font", font);
        UIManager.put("RadioButton.font", font);
        UIManager.put("RadioButtonMenuItem.font", font);
        UIManager.put("TabbedPane.font", font);
        UIManager.put("TitledBorder.font", font);
        UIManager.put("ToggleButton.font", font);
        UIManager.put("ToolBar.font", font);
    }

    private class Openner
    extends Thread {
        URL adminURL = null;

        private Openner(URL uRL) {
            this.adminURL = uRL;
        }

        /* synthetic */ Openner(1 var2_2, URL uRL) {
            this(uRL);
        }

        public void run() {
            ServerBrowser.this.setAdminURL(this.adminURL);
        }
    }
}

