/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.jigedit.filters;

import org.w3c.jigsaw.http.Request;
import org.w3c.tools.resources.Attribute;
import org.w3c.tools.resources.AttributeHolder;
import org.w3c.tools.resources.AttributeRegistry;
import org.w3c.tools.resources.FileResource;
import org.w3c.tools.resources.InvalidResourceException;
import org.w3c.tools.resources.LongAttribute;
import org.w3c.tools.resources.Resource;
import org.w3c.tools.resources.ResourceReference;
import org.w3c.tools.resources.StringAttribute;
import org.w3c.tools.sorter.Comparable;

public class PutedEntry
extends AttributeHolder
implements Comparable {
    protected static int ATTR_AUTHOR = -1;
    protected static int ATTR_URL = -1;
    protected static int ATTR_FILENAME = -1;
    protected static int ATTR_TIME = -1;

    static {
        Class<?> clazz = null;
        StringAttribute stringAttribute = null;
        try {
            clazz = Class.forName("org.w3c.jigedit.filters.PutedEntry");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
        stringAttribute = new StringAttribute("author", null, 2);
        ATTR_AUTHOR = AttributeRegistry.registerAttribute(clazz, (Attribute)stringAttribute);
        stringAttribute = new StringAttribute("url", null, 2);
        ATTR_URL = AttributeRegistry.registerAttribute(clazz, (Attribute)stringAttribute);
        stringAttribute = new StringAttribute("filename", null, 2);
        ATTR_FILENAME = AttributeRegistry.registerAttribute(clazz, (Attribute)stringAttribute);
        stringAttribute = new LongAttribute("time", null, 2);
        ATTR_TIME = AttributeRegistry.registerAttribute(clazz, (Attribute)stringAttribute);
    }

    final String getAuthor() {
        return this.getString(ATTR_AUTHOR, null);
    }

    final String getFilename() {
        return this.getString(ATTR_FILENAME, null);
    }

    protected String getKey() {
        String string = this.getFilename();
        if (string == null) {
            return this.getURL();
        }
        return string;
    }

    public String getStringValue() {
        return Long.toString(this.getTime());
    }

    final long getTime() {
        return this.getLong(ATTR_TIME, -1L);
    }

    final String getURL() {
        return this.getString(ATTR_URL, null);
    }

    public boolean greaterThan(Comparable comparable) {
        return this.getStringValue().compareTo(comparable.getStringValue()) > 0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static PutedEntry makeEntry(Request request) {
        PutedEntry putedEntry;
        ResourceReference resourceReference = request.getTargetResource();
        Resource resource = null;
        if (resourceReference == null) return null;
        try {
            try {
                resource = resourceReference.lock();
                PutedEntry putedEntry2 = new PutedEntry();
                putedEntry2.setValue(ATTR_URL, request.getURL().toExternalForm());
                if (resource instanceof FileResource) {
                    putedEntry2.setValue(ATTR_FILENAME, ((FileResource)resource).getFile().getAbsolutePath());
                }
                putedEntry2.update(request);
                putedEntry = putedEntry2;
                Object var5_6 = null;
            }
            catch (InvalidResourceException invalidResourceException) {
                PutedEntry putedEntry3 = null;
                Object var5_7 = null;
                resourceReference.unlock();
                return putedEntry3;
            }
        }
        catch (Throwable throwable) {
            Object var5_8 = null;
            resourceReference.unlock();
            throw throwable;
        }
        resourceReference.unlock();
        return putedEntry;
    }

    synchronized void update(Request request) {
        String string = (String)request.getState("org.w3c.jigsaw.auth.AuthFilter.user");
        long l = System.currentTimeMillis();
        this.setValue(ATTR_AUTHOR, string);
        this.setValue(ATTR_TIME, new Long(l));
    }
}

