/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.jigedit.filters;

import java.io.IOException;
import java.io.InputStream;
import org.w3c.jigedit.filters.PutFilter;
import org.w3c.jigsaw.frames.HTTPFrame;
import org.w3c.jigsaw.http.Reply;
import org.w3c.jigsaw.http.Request;
import org.w3c.tools.resources.Attribute;
import org.w3c.tools.resources.AttributeRegistry;
import org.w3c.tools.resources.FramedResource;
import org.w3c.tools.resources.InvalidResourceException;
import org.w3c.tools.resources.ReplyInterface;
import org.w3c.tools.resources.RequestInterface;
import org.w3c.tools.resources.ResourceReference;
import org.w3c.tools.resources.StringArrayAttribute;
import org.w3c.tools.resources.StringAttribute;

public class GrepPutFilter
extends PutFilter {
    protected ByteArrayComp[] forbiddenBytes = null;
    protected static int ATTR_FORBIDSTRING_ARRAY = -1;
    protected static int ATTR_REDIRECT = -1;

    static {
        Class<?> clazz = null;
        StringArrayAttribute stringArrayAttribute = null;
        try {
            clazz = Class.forName("org.w3c.jigedit.filters.GrepPutFilter");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
        stringArrayAttribute = new StringArrayAttribute("forbidden-strings", null, 6);
        ATTR_FORBIDSTRING_ARRAY = AttributeRegistry.registerAttribute(clazz, (Attribute)stringArrayAttribute);
        stringArrayAttribute = new StringAttribute("redirect-url", null, 6);
        ATTR_REDIRECT = AttributeRegistry.registerAttribute(clazz, (Attribute)stringArrayAttribute);
    }

    protected ByteArrayComp[] getForbiddenBytes() {
        if (this.forbiddenBytes == null) {
            String[] stringArray = this.getForbiddenStrings();
            this.forbiddenBytes = new ByteArrayComp[stringArray.length];
            int n = 0;
            while (n < stringArray.length) {
                this.forbiddenBytes[n] = new ByteArrayComp(stringArray[n]);
                ++n;
            }
        }
        return this.forbiddenBytes;
    }

    protected String[] getForbiddenStrings() {
        return (String[])this.getValue(ATTR_FORBIDSTRING_ARRAY, null);
    }

    protected String getRedirectURL() {
        return (String)this.getValue(ATTR_REDIRECT, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ReplyInterface ingoingFilter(RequestInterface requestInterface) {
        String string;
        ReplyInterface replyInterface = super.ingoingFilter(requestInterface);
        if (replyInterface != null) {
            return replyInterface;
        }
        Request request = (Request)requestInterface;
        if (!request.getMethod().equals("PUT")) {
            return null;
        }
        InputStream inputStream = null;
        try {
            inputStream = request.getInputStream();
            if (inputStream == null) {
                return null;
            }
        }
        catch (IOException iOException) {
            return null;
        }
        ResourceReference resourceReference = request.getTargetResource();
        if (resourceReference != null) {
            block15: {
                ReplyInterface replyInterface2;
                block16: {
                    ReplyInterface replyInterface3;
                    block14: {
                        try {
                            try {
                                FramedResource framedResource = (FramedResource)resourceReference.lock();
                                HTTPFrame hTTPFrame = null;
                                try {
                                    hTTPFrame = (HTTPFrame)framedResource.getFrame(Class.forName("org.w3c.jigsaw.frames.HTTPFrame"));
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    classNotFoundException.printStackTrace();
                                }
                                if (hTTPFrame == null) {
                                    replyInterface3 = null;
                                    Object var8_13 = null;
                                    break block14;
                                }
                                if (hTTPFrame.getPutableFlag()) break block15;
                                replyInterface2 = null;
                                break block16;
                            }
                            catch (InvalidResourceException invalidResourceException) {
                                invalidResourceException.printStackTrace();
                                break block15;
                            }
                        }
                        catch (Throwable throwable) {
                            Object var8_16 = null;
                            resourceReference.unlock();
                            throw throwable;
                        }
                    }
                    resourceReference.unlock();
                    return replyInterface3;
                }
                Object var8_14 = null;
                resourceReference.unlock();
                return replyInterface2;
            }
            Object var8_15 = null;
            resourceReference.unlock();
        }
        if ((string = this.searchForbiddenStrings(inputStream)) != null) {
            Reply reply = request.makeReply(403);
            reply.setReason("the string \"" + string + "\" is forbidden.");
            reply.setContent("<p>the string \"" + string + "\" is forbidden.</p><br> click " + "<A HREF=\"" + this.getRedirectURL() + "\">here</A>" + " for explaination.");
            return reply;
        }
        return null;
    }

    protected String searchForbiddenStrings(InputStream inputStream) {
        if (this.getForbiddenStrings() == null) {
            return null;
        }
        try {
            int n;
            ByteArrayComp[] byteArrayCompArray = this.getForbiddenBytes();
            int n2 = inputStream.available();
            inputStream.mark(n2);
            int n3 = byteArrayCompArray.length;
            int n4 = 0;
            while (n4 < n3) {
                byteArrayCompArray[n4].reset();
                ++n4;
            }
            while ((n = inputStream.read()) != -1) {
                int n5 = 0;
                while (n5 < n3) {
                    if (byteArrayCompArray[n5].matchNow((byte)n)) {
                        inputStream.reset();
                        return byteArrayCompArray[n5].getString();
                    }
                    ++n5;
                }
            }
            inputStream.reset();
            return null;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public void setValue(int n, Object object) {
        super.setValue(n, object);
        if (n == ATTR_FORBIDSTRING_ARRAY) {
            this.forbiddenBytes = null;
        }
    }

    class ByteArrayComp {
        byte[] tab = null;
        String string = null;
        int idx = -1;
        int length = -1;

        ByteArrayComp(String string) {
            this.tab = string.getBytes();
            this.idx = 0;
            this.length = this.tab.length;
            this.string = string;
        }

        String getString() {
            return this.string;
        }

        boolean matchNow(byte by) {
            if (this.tab[this.idx++] == by) {
                return this.idx == this.length;
            }
            this.idx = 0;
            return false;
        }

        void reset() {
            this.idx = 0;
        }
    }
}

