/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.jigadmin.widgets;

import java.awt.Component;
import java.awt.FlowLayout;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.w3c.jigadmin.widgets.IntegerTextField;

public class EditableSlider
extends JPanel {
    ChangeListener cl = new ChangeListener(){

        public void stateChanged(ChangeEvent changeEvent) {
            String string;
            if (changeEvent.getSource() == EditableSlider.this.slider && !(string = String.valueOf(EditableSlider.this.slider.getValue())).equals(EditableSlider.this.textfield.getText())) {
                EditableSlider.this.textfield.setText(string);
            }
        }
    };
    DocumentListener dl = new DocumentListener(){

        public void changedUpdate(DocumentEvent documentEvent) {
            this.update();
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            this.update();
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            this.update();
        }

        private void update() {
            try {
                int n = Integer.parseInt(EditableSlider.this.textfield.getText());
                if (n <= EditableSlider.this.slider.getMaximum() && n >= EditableSlider.this.slider.getMinimum()) {
                    EditableSlider.this.slider.setValue(n);
                }
            }
            catch (NumberFormatException numberFormatException) {}
        }
    };
    protected JSlider slider = null;
    protected IntegerTextField textfield = null;

    public EditableSlider(int n, int n2, int n3, int n4) {
        super(new FlowLayout());
        this.slider = new JSlider(n, n2, n4);
        this.slider.setMajorTickSpacing(n3);
        this.slider.setPaintLabels(true);
        this.slider.setPaintTicks(true);
        this.slider.setPaintTrack(true);
        this.slider.setSnapToTicks(false);
        this.textfield = new IntegerTextField(8);
        this.textfield.setText(String.valueOf(n4));
        this.textfield.setBorder(BorderFactory.createLoweredBevelBorder());
        this.slider.addChangeListener(this.cl);
        this.textfield.getDocument().addDocumentListener(this.dl);
        this.add((Component)this.textfield, "West");
        this.add((Component)this.slider, "Center");
    }

    public JSlider getSlider() {
        return this.slider;
    }

    public int getValue() {
        return this.slider.getValue();
    }

    public void setValue(int n) {
        this.slider.setValue(n);
    }
}

