// PointMapEntry.java
// $Id: PointMapEntry.java,v 1.5 1998/02/19 10:48:38 bmahe Exp $
// (c) COPYRIGHT MIT and INRIA, 1996.
// Please first read the full copyright statement in file COPYRIGHT.html

package org.w3c.jigsaw.map ;

import java.io.*;
import java.util.*;

class PointMapEntry extends MapEntry {
    private static final String errorString = "point parse error" ;

    Point p;

    public PointMapEntry()
    {
	// nil
    }

    public PointMapEntry(Point p)
    {
	this.p = p;
    }

    public void setPoint(Point p)
    {
	this.p = p;
    }

    public int distanceSquared(Point p)
    {
	return this.p.distanceSquared(p);
    }

    // Shouldn't be called:
    public boolean matches(Point p)
    {
	return true;
    }

    protected void unpickleRest(DataInputStream in)
	throws IOException
    {
	p = new Point();
	p.unpickle(in);
    }

    public void pickle(DataOutputStream out)
	throws IOException
    {
	super.pickle(out);
	out.writeInt(POINT);
	p.pickle(out);
    }

    protected void parseRestNCSA(String line)
    {
	StringTokenizer strtok = new StringTokenizer(line);
	try {
	    URL = strtok.nextToken();
	    p = Point.parseNCSA(strtok.nextToken());
	    if(strtok.hasMoreTokens())
		throw new MapException(errorString);
	} catch(NoSuchElementException ex) {
	    throw new MapException(errorString);
	} catch(NumberFormatException ex) {
	    throw new MapException(errorString);
	}
    }
    
    protected void parseRestW3C(String line)
    {
	StringTokenizer strtok = new StringTokenizer(line);
	try {
	    p = Point.parseW3C(strtok.nextToken());
	    URL = strtok.nextToken();
	    if(p == null || strtok.hasMoreTokens())
		throw new MapException(errorString);
	} catch(NoSuchElementException ex) {
	    throw new MapException(errorString);
	} catch(NumberFormatException ex) {
	    throw new MapException(errorString);
	}
    }
	    
}
