// ConfigResource.java
// $Id: ConfigResource.java,v 1.6 1998/10/29 11:44:10 bmahe Exp $
// (c) COPYRIGHT MIT and INRIA, 1996.
// Please first read the full copyright statement in file COPYRIGHT.html

package org.w3c.jigsaw.http;

import java.util.*;

import org.w3c.tools.resources.*;

class ConfigResourceEnumeration implements Enumeration {
    private static final String ids[] = {
	"space",
	"properties",
	"indexers",
	"realms",
	"control"
    };
    int idx = 0;

    public boolean hasMoreElements() {
	return idx < ids.length;
    }

    public Object nextElement() {
	if ( idx >= ids.length )
	    throw new NoSuchElementException("config resource enumeration");
	return ids[idx++];
    }

    ConfigResourceEnumeration() {
	this.idx = 0;
    }
}

class PropertySetEnumeration implements Enumeration {
    Enumeration e = null;

    public boolean hasMoreElements() {
	return e.hasMoreElements();
    }

    public Object nextElement() {
	return ((Resource) e.nextElement()).getIdentifier();
    }

    protected PropertySetEnumeration(Enumeration e) {
	this.e = e;
    }

}

class PropertiesConfig extends AbstractContainer {
    httpd server = null;

    public void registerResource(String n, Resource c, Hashtable d) {
	throw new RuntimeException("static container");
    }

    public ResourceReference createDefaultResource(String name) {
	throw new RuntimeException("static container");
    }

    public void delete(String name) {
	throw new RuntimeException("static container");
    }	

    public Enumeration enumerateResourceIdentifiers(boolean all) {
	return new PropertySetEnumeration(server.enumeratePropertySet());
    }

    public ResourceReference lookup(String name) {
	return new DummyResourceReference(server.getPropertySet(name));
    }

    protected PropertiesConfig(httpd server) {
	this.server = server;
    }

}

public class ConfigResource extends AbstractContainer {
    protected httpd server = null;
    protected ResourceReference propConfig = null;
    protected ResourceReference realmConfig = null;
    protected ResourceReference controlConfig = null;
    protected ResourceReference indexers = null;

    public void registerResource(String n, Resource c, Hashtable d) {
	throw new RuntimeException("static container");
    }

    public ResourceReference createDefaultResource(String name) {
	throw new RuntimeException("static container");
    }

    public void delete(String name) {
	throw new RuntimeException("static container");
    }	

    public Enumeration enumerateResourceIdentifiers(boolean all) {
	return new ConfigResourceEnumeration();
    }

    public ResourceReference lookup(String name) {
	if ( name.equals("space") ) {
	    return server.getEditRoot();
	} else if ( name.equals("properties") ) {
	    return propConfig;
	} else if ( name.equals("indexers") ) {
	    return indexers;
	} else if ( name.equals("realms" ) ) {
	    return realmConfig;
	} else if ( name.equals("control") ) {
	    return controlConfig;
	}
	return null;
    }

    public ConfigResource(httpd server) {
	this.server = server;
	this.propConfig = 
	    new DummyResourceReference(new PropertiesConfig(server));
	this.realmConfig = 
	    new DummyResourceReference(server.getRealmsCatalog());
	this.controlConfig = 
	    new DummyResourceReference(new ControlResource(server));
	this.indexers = 
	    new DummyResourceReference( server.getIndexersCatalog() );
    }

}
