// ListEditor.java
// $Id: ListEditor.java,v 1.6 1998/10/01 08:12:34 bmahe Exp $
// Author: bmahe@sophia.inria.fr
// (c) COPYRIGHT MIT and INRIA, 1997.
// Please first read the full copyright statement in file COPYRIGHT.html

package org.w3c.tools.widgets;

import java.awt.*;
import java.awt.event.*;
import java.math.*;

/**
 * ListEditor :
 * @author Benoit Mahe <bmahe@sophia.inria.fr>
 */

public abstract class ListEditor extends BorderPanel 
                                 implements ActionListener 
{

    protected List   list       = null;
    protected Button editButton = null;
  
    protected abstract void edit();

    /**
     * ActionListsner implementation - One of our button was fired.
     * @param evt The ActionEvent.
     */

    public void actionPerformed(ActionEvent evt) {
	String command = evt.getActionCommand();
	if ( command.equals("edit" ) )
	    edit();
    }

    public ListEditor() {
	this(5,false);
    }

    public ListEditor(int nbVisible, boolean multiple) {
	super(IN, 2);
	setInsets(new Insets(4,4,4,4));
	editButton = new Button ("Edit");
	editButton.setActionCommand("edit");
	editButton.addActionListener(this);
	list = new List(nbVisible, multiple);

	setLayout(new BorderLayout());
	add(list, "Center");
	add(editButton,"East");
    }

}
