// ZipFrame.java
// $Id: ZipFrame.java,v 1.6 1998/08/14 11:12:50 bmahe Exp $
// (c) COPYRIGHT MIT and INRIA, 1998.
// Please first read the full copyright statement in file COPYRIGHT.html

package org.w3c.jigsaw.zip;

import java.util.zip.*;
import java.util.*;
import java.io.*;

import org.w3c.util.*;
import org.w3c.tools.resources.*;
import org.w3c.jigsaw.frames.*;
import org.w3c.jigsaw.http.* ;
import org.w3c.jigsaw.html.* ;
import org.w3c.www.mime.*;
import org.w3c.www.http.*;
import org.w3c.tools.resources.ProtocolException;
import org.w3c.tools.resources.ResourceException;

/**
 * @version $Revision: 1.6 $
 * @author  Benot Mah (bmahe@w3.org)
 */
public class ZipFrame extends HTTPFrame {
    
    protected ZipFileResource zipfresource = null;

    public void registerResource(FramedResource resource) {
	super.registerResource(resource);
	if (resource instanceof ZipFileResource)
	    zipfresource = (ZipFileResource) resource;
    }

    /**
     * Create the reply relative to the given file.
     * @param request the incomming request.
     * @return A Reply instance
     * @exception org.w3c.tools.resources.ProtocolException if processing 
     * the request failed.
     * @exception org.w3c.tools.resources.ResourceException if the resource
     * got a fatal error.
     */
    protected Reply createFileReply(Request request) 
	throws ProtocolException, ResourceException
    {
	Reply reply = null;
	if (zipfresource == null) {
	    throw new ResourceException("this frame is not attached to a "+
					"ZipFileResource. ("+
					resource.getIdentifier()+")");
	}
	// Default to full reply:
	reply = createDefaultReply(request, HTTP.OK) ;
	InputStream in = zipfresource.getInputStream();
	if (in != null)
	    reply.setStream(in);
	return reply ;
    }

    /**
     * The default PUT method replies with a not implemented.
     * @param request The request to handle.
     * @exception ProtocolException Always thrown, to return a NOT_IMPLEMENTED
     * error.
     * @exception ResourceException If the resource got a fatal error.
     */

    public Reply put(Request request)
	throws ProtocolException, ResourceException
    {
	Reply error = request.makeReply(HTTP.NOT_IMPLEMENTED) ;
	error.setContent("Method PUT not implemented for zipped document") ;
	throw new HTTPException (error) ;
    }
}
