// ConnectionProp.java
// $Id: SocketConnectionProp.java,v 1.5 1998/01/22 14:06:10 bmahe Exp $
// (c) COPYRIGHT MIT and INRIA, 1996.
// Please first read the full copyright statement in file COPYRIGHT.html

package org.w3c.jigsaw.http.socket;

import java.io.* ;
import java.util.* ;

import org.w3c.tools.resources.*;
import org.w3c.jigsaw.http.* ;
//import org.w3c.jigsaw.forms.* ;
import org.w3c.jigsaw.daemon.*;
import org.w3c.jigsaw.config.*;
import org.w3c.www.http.*;

public class SocketConnectionProp extends PropertySet {
    private static String title = "Socket connection properties";

    static {
	Class     c = null;
	Attribute a = null;
	
	try {
          c = Class.forName("org.w3c.jigsaw.http.socket.SocketConnectionProp");
	} catch (Exception ex) {
	    ex.printStackTrace();
	    System.exit(1);
	}
	// Minimum number of free spare threads
	a = new IntegerAttribute(SocketClientFactory.MINSPARE_FREE_P
			       , new Integer(SocketClientFactory.MINSPARE_FREE)
			       , Attribute.EDITABLE);
	AttributeRegistry.registerAttribute(c, a);
	// Maximum number of free spare threads
	a = new IntegerAttribute(SocketClientFactory.MAXSPARE_FREE_P
			       , new Integer(SocketClientFactory.MAXSPARE_FREE)
			       , Attribute.EDITABLE);
	AttributeRegistry.registerAttribute(c, a);
	// Maximum number of idle threads:
	a = new IntegerAttribute(SocketClientFactory.MAXSPARE_IDLE_P
			       , new Integer(SocketClientFactory.MAXSPARE_IDLE)
			       , Attribute.EDITABLE);
	AttributeRegistry.registerAttribute(c, a);
	// Maximum number of simultaneous connections:
	a = new IntegerAttribute(SocketClientFactory.MAXCLIENTS_P
			       , new Integer(SocketClientFactory.MAXCLIENTS)
			       , Attribute.EDITABLE);
	AttributeRegistry.registerAttribute(c, a);
	// Idle timeout for thread cache
	a = new IntegerAttribute(SocketClientFactory.IDLETO_P
			       , new Integer(SocketClientFactory.IDLETO)
			       , Attribute.EDITABLE);
	AttributeRegistry.registerAttribute(c, a);
	// Max number of threads
	a = new IntegerAttribute(SocketClientFactory.MAXTHREADS_P
				 , new Integer(SocketClientFactory.MAXTHREADS)
				 , Attribute.EDITABLE);
	AttributeRegistry.registerAttribute(c, a);
    }

    /**
     * Get this property set title.
     * @return A String giving the title for this property set.
     */

    public String getTitle() {
	return title;
    }

    SocketConnectionProp(String name, httpd server) {
	super(name, server);
    }
}
