/*
 *  SymbolToBoolean.java
 *
 *  Copyright 1997 Massachusetts Institute of Technology.
 *  All Rights Reserved.
 *
 *  Author: Ora Lassila
 *
 *  $Id: SymbolToBoolean.java,v 1.1 1997/05/30 13:24:11 bmahe Exp $
 */

package w3c.www.pics;

public class SymbolToBoolean implements Mapper {

  public Object map(Object value) throws PICSParserException
  {
    if (value == PICS.TRUE)
      return Boolean.TRUE;
    else if (value == PICS.FALSE)
      return Boolean.FALSE;
    else
      throw new PICSParserException("Illegal boolean value " + value);
  }

}
