// SliderWidget.java
// $Id: SliderWidget.java,v 1.2 1997/07/04 08:42:11 bmahe Exp $
// Author: bmahe@sophia.inria.fr
// (c) COPYRIGHT MIT and INRIA, 1997.
// Please first read the full copyright statement in file COPYRIGHT.html

package w3c.tools.widgets;

import java.awt.*;
import java.awt.event.*;

public class SliderWidget extends Container {

  Slider slider        = null;
  Label label          = null;
  Panel panel          = null;
  LayoutManager layout = null;

  public Dimension getPreferredSize() { 
    return layout.preferredLayoutSize(panel);
  }

  

  public SliderWidget (String title, 
		       int min, 
		       int max, 
		       int step, 
		       int minPixelStep,
		       Color color) {
    setLayout( new BorderLayout());
    slider = new Slider(min,max,step,minPixelStep,false,color);
    panel = new Panel();
    label = new Label (title+" : ");
    layout = new BorderLayout();
    panel.setLayout( layout );
    panel.add(label, BorderLayout.WEST);
    panel.add(slider, BorderLayout.EAST);
    add(panel);
    validate();
  }

  public static void main(String argv[]) {
    Frame f = new Frame ("Slider Widget");
    SliderWidget sl = new SliderWidget ("Port",8000, 8010, 1, 3,Color.gray);
    f.add(sl);
    f.pack();
    f.show ();
  }
}
