// SpaceBrowser.java
// $Id: SpaceBrowser.java,v 1.2 1997/07/30 14:10:27 ylafon Exp $  
// (c) COPYRIGHT MIT and INRIA, 1997.
// Please first read the full copyright statement in file COPYRIGHT.html

package w3c.tools.resources.tests;

import java.awt.*;
import java.rmi.*;
import java.util.*;

import w3c.tools.widgets.*;
import w3c.tools.resources.rmi.*;

class ResourceNodeHandler implements NodeHandler {
    public static String UNCOLLAPSED_IMG
    = "/u/koala/0/koala/leon/dev/java/classes/koala/images/diropened.gif";
    public static String COLLAPSED_IMG 
    = "/u/koala/0/koala/leon/dev/java/classes/koala/images/dir.gif";
    public static String RESOURCE_IMG 
    = "/u/koala/0/koala/leon/dev/java/classes/koala/images/file.gif";
    
    public java.awt.Image getIcon(RemoteResource resource, boolean open) {
	String iname = null;
	try {
	    Object icon = resource.getValue("icon");
	    if ( icon instanceof String )
		iname = (String) icon;
	} catch (Exception ex) {
	}
	if ( iname == null )
	    iname = ((resource instanceof RemoteResourceContainer)
		     ? (open ? UNCOLLAPSED_IMG : COLLAPSED_IMG)
		     : RESOURCE_IMG);
	return Toolkit.getDefaultToolkit().getImage(iname);
    }

    public void notifySelect(TreeBrowser view, TreeNode node) {
	view.select(node);
	view.repaint();
    }
    
    public void notifyExpand(TreeBrowser view, TreeNode node) {
	// Of course we shouldn't keep the RemoteResource straight
	ClientResource cr = (ClientResource) node.getItem();
	if ( cr.isContainer() ) {
	    try {
		RemoteResourceContainer rrc = null;
		rrc = (RemoteResourceContainer) cr.getTarget();
		String children[] = rrc.listChildNames();
		for (int i = 0 ; i < children.length ; i++) {
		    RemoteResource rr = rrc.resolve(children[i]);
		    ClientResource ccr = ClientResource.get(rr);
		    view.insert(node, ccr, this, ccr.name, ccr.getIcon(true));
		}
	    } catch (Exception ex) {
		ex.printStackTrace();
	    }
	}
	node.setIcon(cr.getIcon(true));
	view.repaint();
    }
    
    public void notifyCollapse(TreeBrowser view, TreeNode node) {
	ClientResource cr = (ClientResource) node.getItem();
	node.setIcon(cr.getIcon(false));
	view.collapse(node);
	view.repaint();
    }

    public void notifyExecute(TreeBrowser view, TreeNode node) {
	ClientResource cr = (ClientResource) node.getItem();
	Panel editor = cr.getEditor();
	// Build up a toplevel frame
	Frame top = new Frame(cr.name);
	top.add("Center", editor);
	top.resize(400, 400);
	top.pack();
	top.show();
    }

    public boolean isDirectory(TreeBrowser view, TreeNode node) {
	ClientResource cr = (ClientResource) node.getItem();
	return cr.isContainer();
    }

}

public class SpaceBrowser {

    public static void main(String args[]) {
	try {
	    String name = "//"+args[0]+"/"+args[1];
	    RemoteResourceSpace space = ((RemoteResourceSpace) 
					 Naming.lookup(name));
	    // Get the root resource by resolving '/':
	    ClientResource root = ClientResource.get(space.resolve("/"));
	    ResourceNodeHandler handler = new ResourceNodeHandler();
	    TreeBrowser view = new TreeBrowser(root
					       , root.name
					       , new ResourceNodeHandler()
					       , root.getIcon(true));
	    // Create and fill in the toplevel:
	    Frame toplevel = new Frame(args[1]);
	    Scrollbar vscroll = new Scrollbar(Scrollbar.VERTICAL);
	    view.setVerticalScrollbar(vscroll);
	    toplevel.add("East", vscroll);
	    toplevel.add("Center", view);
	    toplevel.pack();
	    toplevel.resize(400, 400);
	    toplevel.show();
	} catch (Exception ex) {
	    ex.printStackTrace();
	}
    }

}
