// RemoteResourceSpaceImpl.java
// $Id: RemoteResourceSpaceImpl.java,v 1.3 1997/07/30 14:09:29 ylafon Exp $  
// (c) COPYRIGHT MIT and INRIA, 1997.
// Please first read the full copyright statement in file COPYRIGHT.html

package w3c.tools.resources.rmi;

import java.rmi.*;

import w3c.tools.resources.*;

public class RemoteResourceSpaceImpl 
    extends java.rmi.server.UnicastRemoteObject
    implements RemoteResourceSpace 
{
    protected ResourceSpace space = null;

    protected RemoteResourceImpl makeRemoteResource(ResourceReference rr) {
	try {
	    Resource           r   = rr.lock();
	    RemoteResourceImpl ret = null;
	    if ( r instanceof ResourceContainer ) 
		ret = new RemoteResourceContainerImpl(this, rr);
	    else 
		ret = new RemoteResourceImpl(this, rr);
	    return ret;
	} catch (RemoteException ex) {
	    ex.printStackTrace(); 
	} finally {
	    rr.unlock();
	}
	return null;
    }

    public RemoteResource resolve(String path) {
	LookupState       state = new LookupState(space, path);
	ResourceReference ref   = space.resolve(state);
	return makeRemoteResource(ref);
    }

    public static void exportResourceSpace(String name, ResourceSpace space) {
	try {
	    // Create a new "broker":
	    RemoteResourceSpaceImpl rrs = new RemoteResourceSpaceImpl(space);
	    // Register it:
	    Naming.rebind("//www43.inria.fr/"+name, rrs);
	} catch (Exception ex) {
	    ex.printStackTrace();
	}
    }

    protected RemoteResourceSpaceImpl(ResourceSpace space) 
	throws RemoteException
    {
	this.space = space;
    }

}
