// PropertyResourceFilter.java
// $Id: PropertyResourceFilter.java,v 1.4 1997/07/30 14:08:24 ylafon Exp $  
// (c) COPYRIGHT MIT and INRIA, 1997.
// Please first read the full copyright statement in file COPYRIGHT.html

package w3c.tools.resources.property;

import java.io.*;

/**
 * The FilenameFilter for Properties Resources Files.
 */

public class PropertyResourceFilter implements FilenameFilter {


  /**
   * Tests if a specified file should be included in a file list. 
   * @param dir - the directory in which the file was found. 
   *        name - the name of the file. 
   * @return true if the name should be included in the file list; 
   * false otherwise.
   */
  public boolean accept(File dir, String name) {
    File f = new File(dir,name);
    if (f.isDirectory()) return false;
    String ext = name.substring(name.length()-2);
    if (ext.equals(".p")) return true;
    return false;
  }

}
