// StructureChangedEvent.java
// $Id: StructureChangedEvent.java,v 1.3 1997/07/30 14:06:34 ylafon Exp $  
// (c) COPYRIGHT MIT and INRIA, 1997.
// Please first read the full copyright statement in file COPYRIGHT.html

package w3c.tools.resources.event;

import w3c.tools.resources.*;

public class StructureChangedEvent extends java.util.EventObject {
    /**
     * The source is loaded (initialized and attached to a space).
     */
    public static final int RESOURCE_INITED = 1;
    /**
     * The source has just been unloaded from memory.
     */
    public static final int RESOURCE_UNLOADED = 2;
    /**
     * A new resource has been created.
     */
    public static final int RESOURCE_CREATED = 3;
    /**
     * Some resource is about to be deleted.
     */
    public static final int RESOURCE_DELETED = 4;

    /**
     * The type of that event.
     */
    protected int type = -1;
    /**
     * The resource being acted upon.
     */
    protected Resource resource = null;

    /**
     * Get the resource that triggered the event.
     * @return A Resource instance.
     */

    public Resource getResource() {
	return resource;
    }

    /**
     * Create a structure change event.
     * @param source The resource emitting the event.
     * @param type The kind of event being emitted.
     */

    public StructureChangedEvent(ResourceSpace space
				 , Resource resource
				 , int type) {
	super(space);
	this.resource = resource;
	this.type     = type;
    }
}
