// ConvertVector.java
// $Id: ConvertVector.java,v 1.2 1997/07/30 14:06:09 ylafon Exp $  
// (c) COPYRIGHT MIT and INRIA, 1997.
// Please first read the full copyright statement in file COPYRIGHT.html

package w3c.tools.resources.converter;

import java.util.*;

public class ConvertVector implements Convert {

  public void setInitialClass(Class c){}

  public Object defaultValue() {
    return new Vector();
  }

  public String toString(Object O) 
    throws NoSuchConverterException
  {
    StringBuffer buffer = new StringBuffer();
    Enumeration e = ((Vector) O).elements();
    while (e.hasMoreElements()) {
      buffer.append(ConvertRegistry.toString(e.nextElement()));
      if (e.hasMoreElements()) buffer.append("|");
    }
    return new String(buffer);
  }

  public Object toObject(String S) {
    Vector V = new Vector();
    StringTokenizer token = new StringTokenizer(S,"|");
    while (token.hasMoreTokens()) {
      V.addElement(token.nextToken());
    }
    return V;
  }

  public Class classConverted() {
    try {
      return Class.forName("java.util.Vector");
    } catch (ClassNotFoundException ex) {
      System.out.println(ex.getMessage());
      ex.printStackTrace();
      return null;
    }
  }

}
