// ConvertStringArray.java
// $Id: ConvertStringArray.java,v 1.2 1997/07/30 14:06:04 ylafon Exp $  
// (c) COPYRIGHT MIT and INRIA, 1997.
// Please first read the full copyright statement in file COPYRIGHT.html

package w3c.tools.resources.converter;

import java.util.*;

public class ConvertStringArray implements Convert {

  public void setInitialClass(Class c){}

  public Object defaultValue() {
    return new String[0];
  }

  public String toString(Object O) 
    throws NoSuchConverterException
  {
    String array[] = (String[])O;
    StringBuffer buffer = new StringBuffer();
    int idx = 0;
    while (idx < array.length) {
      buffer.append(array[idx]);
      if (++idx < array.length) buffer.append("|");
    }
    return new String(buffer);
  }

  public Object toObject(String S) {
    Vector V = new Vector();
    StringTokenizer token = new StringTokenizer(S,"|");
    while (token.hasMoreTokens()) {
      V.addElement(token.nextToken());
    }
    String array[] = new String [V.size()];
    V.copyInto(array);
    return array;
  }

  public Class classConverted() {
    String array [] = new String [1];
    return array.getClass();
  }

}
