// AsciiResourceStore.java
// $Id: AsciiResourceStore.java,v 1.3 1997/07/30 14:04:56 ylafon Exp $  
// (c) COPYRIGHT MIT and INRIA, 1997.
// Please first read the full copyright statement in file COPYRIGHT.html

package w3c.tools.resources.ascii;
 
import java.util.*;
import java.io.*;
import w3c.tools.resources.*;
import w3c.tools.resources.impl.*;

 
public class AsciiResourceStore implements ResourceStore {

  protected File store = null;

  protected AsciiResourceSaver saver = null;
  
  public PersistentReference getPersistentReference (String resource) {
    return new PersistentReferenceImpl(store.getAbsolutePath(),resource);
  }
 
  public Enumeration listResourceName() {
    return saver.listResourceName();
  }
 
  public File getResourceFile(String name){
    return null;
  }

   public File getDirectory() {
    return store;
  }
 
  public void setSaver(AsciiResourceSaver saver) {
    this.saver = saver;
  }

  public void init(String init)
    throws ResourceStoreInitException
  {
    this.store = new File(init);
    if (! store.exists()) store.mkdirs(); 
    if (! store.isDirectory()) 
      throw new ResourceStoreInitException("Can't create "+
					   store.getAbsolutePath());
  }
 
  public ResourceStore addStore(String name)
    throws ResourceStoreInitException
  {
    throw new ResourceStoreInitException("Error : add store in Ascii Space : "+
					 name);
  }

  public ResourceStore getNewStore(File directory) 
    throws ResourceStoreInitException
  {
    throw new ResourceStoreInitException("Error : new store in Ascii Space : "+
					 directory.getAbsolutePath());
  }
  
  public AsciiResourceStore() {

  }

}
