// ResourceContext.java
// $Id: ResourceContext.java,v 1.4 1997/07/30 14:03:23 ylafon Exp $  
// (c) COPYRIGHT MIT and INRIA, 1997.
// Please first read the full copyright statement in file COPYRIGHT.html

package w3c.tools.resources;

/**
 * The context that gets passed to create/init a resource.
 */

public interface ResourceContext {

  public ResourceContext getClone();

  /**
   * The space that resource is to be created/inited in.
   * @param space A resource space implementation.
   */

  public ResourceSpace getResourceSpace();

  /**
   * The associated reference for that resource.
   * @return A ResourceReference implementation.
   */

  public ResourceReference getResourceReference();
  public void setResourceReference(ResourceReference ref);

  /**
   * The <em>container</em> for that resource, if any.
   * Passing the container around allows for propagating init infos along
   * the hierarchy of containment.
   * @return The parent resource reference, or <strong>null</strong>.
   */

  public ResourceReference getContainer();
  public void setContainer(ResourceReference ref);

  /**
   * Default property values for the resource.
   * This is used only for creating resources.
   * @return A Dictionary mapping attribute names to attribute values, 
   * or <strong>null</strong> if no mappings are to be used.
   */

  public String[] getPropertyNames();
  public Object[] getPropertyValues();
  public void addProperty(String name, Object value);
  public Object getProperty(String name);

  /**
   * Get the agrregate for that rresource if any.
   * Resources can delegate part of their functionalities to delegatee, this
   * method will return the aggregator of the delegatee about to be created
   * or initialized, or <strong>null</strong> if that resource is
   * "standalone".
   * @return A ResourceReference to the aggregate resource, or <strong>
   * null</strong>.
   */

  public ResourceReference getAggregate();
  public void setAggregate(ResourceReference aggregate);
    
}
