// ResourceContainer.java
// $Id: ResourceContainer.java,v 1.5 1997/07/30 14:03:18 ylafon Exp $  
// (c) COPYRIGHT MIT and INRIA, 1997.
// Please first read the full copyright statement in file COPYRIGHT.html

package w3c.tools.resources;

import java.util.*;

/**
 * Interface for container resources.
 * A resource container manages a set of children resources, this is the
 * basis for providing hierarchical resource spaces and managing them.
 */
 
public interface ResourceContainer {

  /**
   * Register and init the given resource as a new child of the container.
   * @param resource The resource to be added as a child.
   * @param ctxt The init context to be used to init the child.
   * @exception ChildNotSupportedException If the container doesn't
   * support that kind of a child.
   * @exception ResourceInitException If the resource didn't init.
   * @exception SecurityException If that access is denied.
   */

  public ResourceReference registerChild(Resource resource, 
					 ResourceContext ctxt)
    throws ChildNotSupportedException, ResourceInitException;

  
  public ResourceReference loadChild(String name);


  /**
   * Unregister and delete the given child resource.
   * @param child The child resource to delete.
   * @exception SecurityException If that access is denied.
   */

  public void deleteChild(Resource child);

  /**
   * Unregister and delete the child (if any) that has the given name.
   * @param name The name of the child resource to delete.
   * @exception SecurityException If that access is denied.
   */

  public void deleteChild(String name);

  /**
   * Enumerate all child resource names.
   * @return An enumeration of String instances, providing each
   * child resource names
   * @exception SecurityException If that access is denied.
   */

  public Enumeration listChildNames();

  /**
   * Enumerate all child resources.
   * @return An enumeration of ResourceReference instances.
   * @exception SecurityException If that access is denied.
   */

  public Enumeration listChildren();

  //  public Resource getParent();

  

}
