// PropertyHolder.java
// $Id: PropertyHolder.java,v 1.2 1997/07/30 14:03:07 ylafon Exp $  
// (c) COPYRIGHT MIT and INRIA, 1997.
// Please first read the full copyright statement in file COPYRIGHT.html

package w3c.tools.resources;

import java.util.*;
import java.lang.reflect.*;
import java.beans.*;

import w3c.tools.resources.*;
import w3c.tools.resources.event.*;


public interface PropertyHolder {

  /**
   * Set any attribute, catching any exception.
   */
  public void protectedSetValue(String name, Object value);


  public PropertyHolder getClone();

  public Object protectedGetValue(String name);

  /**
   * Print all the attributes holded by this implementation.
   * @return A String instance.
   */
  public String toString();

  /**
   * Enumerate the attributes property descriptors.
   * @return An enumeration of PropertyDescriptor.
   * @see PropertyDescriptor
   */
  public Enumeration getProperties();

  /**
   * Get an attribute value.
   * @param name The attribute name.
   * @return The attribute value.
   * @exception IllegalAccessException If the attribute isn't supported,
   * @exception IllegalArgumentException If the provided value doesn't match
   * the attribute type.
   */
  public Object getValue(String name)
    throws IllegalAccessException, IllegalArgumentException;
  
  /**
   * Get a set of attribute values.
   * @param names The name of the attributes to fetch.
   * @return An array of attribute values.
   * @exception IllegalAccessException If one of the attribute isn't
   * supported,
   * @exception IllegalArgumentException If one of the provided value
   * doesn't match the attribute type.
   */
  public Object[] getValues(String names[]) 
    throws IllegalAccessException, IllegalArgumentException;

  
  /**
   * Set an attribute value.
   * @param name The name of the attribute.
   * @param value The new value for that attribute.
   */
  public void setValue(String name, Object newvalue)
    throws IllegalAccessException, IllegalArgumentException;

  
  /**
   * Perform a set of attribute changes atomically.
   * @param names The attribute names.
   * @param values The attribute values.
   */
  public void setValues(String names[], Object newvalues[])
    throws IllegalAccessException;

  /**
   * Add an attribute change listener.
   * @param l The new attribute change listener.
   */
  public void addAttributeChangedListener(AttributeChangedListener l);

  /**
   * Remove an attribute change listener.
   * @param l The listener to remove.
   */
  
  public void removeAttributeChangedListener(AttributeChangedListener l);

}
