// Smpte.java
// $Id: Smpte.java,v 1 1997/07/31 10:00 osofia Exp $
// (c) COPYRIGHT MIT and INRIA, 1997.
// Please first read the full copyright statement in file COPYRIGHT.html


package w3c.rtsp.common;

import java.io.*;
import java.util.*;
import java.net.*;
import java.awt.*;


public class Smpte {

  protected int hour=0;
  protected int min=0;
  protected int sec=0;

  public int getHour(){
    return this.hour;
  }

  public int getMin(){
    return this.min;
  }

  public int getSec(){
    return this.sec;
  }
  
  public void setHour(int hour){
    this.hour=hour;
  }

  public void setMin(int min){
    this.min=min;
  }

  public void setSec(int sec){
    this.sec=sec;
  }

  public String toString(){
    return new String(this.hour+":"+this.min+":"+this.sec);
  }

  //return the value in seconds.
  
  public long toSecond(){
    return ((long)(this.hour*3600+this.min*60+this.sec));
  }

  //constructors.

  public Smpte(String st) throws SmpteException{
    StringTokenizer stk=new StringTokenizer(st,":");
    try{
      if(stk.hasMoreTokens()){
	this.hour=Integer.parseInt(stk.nextToken());
	System.out.println("\nHOURS:"+this.hour);
      }
      if(stk.hasMoreTokens()){
	this.min=Integer.parseInt(stk.nextToken());
	System.out.println("\nMIN:"+this.min);
      }
      if(stk.hasMoreTokens()){
	this.sec=Integer.parseInt(stk.nextToken());
	System.out.println("\nSEC:"+this.sec);
      }    
    }catch(NumberFormatException E){
      throw new SmpteException("Unable to parse this format :Smpte format required");
    }
  }

  public Smpte(int hour,int min,int sec){
    this.hour=hour;
    this.min=min;
    this.sec=sec;
  }
  
  public Smpte(int diff){
    this.hour=diff/3600;
    this.min=(diff%3600)/60;
    this.sec=((diff%3600)%60);
  }

}
