package w3c.rtsp.common;

import java.io.*;
import java.util.*;
import java.net.*;
import java.awt.*;


public class RtspState {

  protected String name=null;
  protected RequestLine requestLine=null;
  protected static int sessionNb=0;
  protected String type=null;

  //Construtor default initialized at Init State.

  public RtspState(String type){
    this.sessionNb++;
    this.type=type;
    this.name="Init";
  }

  //Constructor where we can specifie the Begining State. 

 public RtspState(String name,String type){
    this.sessionNb++;
    this.name=name;
    this.type=type;
  }

  //change the current state to the next one depending on if it's a server or a client.

  public int nextState(String method){

    if(this.type.equals("S"))
      return this.nextServerState(method);
    if(this.type.equals("C"))
      return this.nextClientState(method);
    else{
      System.out.println("\nUNKOWN OBJET :\n");
    return -1; 
    }
  }

  public int nextServerState(String method){

    int good=0,bad=-1;

    if(method.equals("SETUP")){
      if(this.name.equals("Init")){
	this.name="Ready";
	return good;
      }
      if(this.name.equals("Playing")){
	this.name="Playing";
	return good;
      }
      if(this.name.equals("Recording")){
	this.name="Recording";
	return good;
      }
      if(this.name.equals("Ready")){
	this.name="Ready";
	return good;
      }
      else 
	return bad;
    }
    if(method.equals("PLAY")){
      if(this.name.equals("Ready")){
	this.name="Playing";
	return good;
      }	
      if(this.name.equals("Playing")){
	this.name="Playing";
	return good;
      } 
      if(this.name.equals("Recording")){
	this.name="Playing";
	  return good;
      }
      else
	return bad;
    }
    if(method.equals("TEARDOWN")){
      if(this.name.equals("Ready")){
	this.name="Ready";
	return good;
      } 
      if(this.name.equals("Recording")){
	this.name="Ready";
	return good;
      }
      if(this.name.equals("Playing")){
	this.name="Ready";
	return good;
      }
      if(this.name.equals("Init")){
	this.name="Init";
	return good;
      }
      else
	return bad;
    }
    if(method.equals("RECORD")){
      if(this.name.equals("Playing")){
	this.name="Recording";
	return good;
      } 
      if(this.name.equals("Recording")){
	this.name="Recording";
	return good;
      }
      else
	return bad;
    }
   if(method.equals("PAUSE")){
      if(this.name.equals("Playing")){
	this.name="Ready";
	return good;
      } 
      if(this.name.equals("Recording")){
	this.name="Ready";
	return good;
      }
      else
	return bad;
    }
   if(method.equals("OPTIONS")){
     return good;
   }
   if(method.equals("DESCRIBE")){
     return good;
   }
   if(method.equals("GET_PARAMETER")){
     return good;
   }
   if(method.equals("SET_PARAMETER")){
     return good;
   }
   return bad;
  } 

  public int nextClientState(String method){

    int good=0,bad=-1;
    
    if(method.equals("SETUP")){
      if(this.name.equals("Init")){
	this.name="Ready";
	return good;
      }
      if(this.name.equals("Playing")){
	this.name="Playing";
	return good;
      }
      if(this.name.equals("Recording")){
	this.name="Recording";
	return good;
      }
      else 
	return bad;
    }
    if(method.equals("PLAY")){
      if(this.name.equals("Ready")){
	this.name="Playing";
	return good;
      }	
      if(this.name.equals("Playing")){
	this.name="Playing";
	return good;
      } 
      if(this.name.equals("Recording")){
	this.name="Playing";
	return good;
      }
      else
	return bad;
    }
    if(method.equals("TEARDOWN")){
      if(this.name.equals("Init")){
	this.name="Init";
	return good;
      } 
      if(this.name.equals("Ready")){
	this.name="Init";
	return good;
      }
      if(this.name.equals("Playing")){
	this.name="Init";
	return good;
      }
      if(this.name.equals("Recording")){
	this.name="Init";
	return good;
      }
      else
	return bad;
    }
    if(method.equals("RECORD")){
      if(this.name.equals("Ready")){
	this.name="Recording";
	return good;
      } 
      if(this.name.equals("Playing")){
	this.name="Recording";
	return good;
      }
      if(this.name.equals("Recording")){
	this.name="Recording";
	return good;
      }
      else
	return bad;
    }
    if(method.equals("PAUSE")){
      if(this.name.equals("Playing")){
	this.name="Ready";
	return good;
      } 
      if(this.name.equals("Recording")){
	this.name="Init";
	return good;
      }
      else
	return bad;
    }
    if(method.equals("OPTIONS")){
      return good;
   }
    if(method.equals("DESCRIBE")){
      return good;
    }
    if(method.equals("GET_PARAMETER")){
      return good;
   }
    if(method.equals("SET_PARAMETER")){
      return good;
    }
    return bad;
  }
  
  public String getName(){
    return this.name;
  }
  
  public int getSessionNb(){
    return this.sessionNb;
  }
} 

