package w3c.rtsp.common;

import java.io.*;
import java.util.*;
import java.net.*;
import java.awt.*;


public class ResponseHeader {


  protected String Location = null ;
  protected String ProxyAuthenticate = null ;
  protected String Public = null ;
  protected String RetryAfter=null;
  protected String Server = null ;
  protected String Vary = null ;
  protected String WWWAuthenticate = null ;
  //  protected String Allow=null;
  //  protected String CacheControl=null;
  // protected String Connection=null;
  // protected RtspDate date=null;
  protected String Range=null;
  protected int Scale=-1;
  protected int Session=-1;
  protected int Speed=-1;
  // protected String Via=null;

  //constructor.

  public ResponseHeader(String Location){
    this.Location=Location;
  }

  //the session is here to retreive the client if the connection is broken.

  public ResponseHeader(int Session){
    this.Session=Session;
  }

  public ResponseHeader(){
  }

  public ResponseHeader(String Location,
			String ProxyAuthenticate,
			String Public,
			String Server,
			String Vary,
			String WWWAuthenticate
			){
    this.Location=Location;
    this.ProxyAuthenticate=ProxyAuthenticate;
    this.Public=Public;
    this.Server=Server;
    this.Vary=Vary;
    this.WWWAuthenticate=WWWAuthenticate;
    //  this.Allow=Allow;
  }


  //emit of this header on the associated client socket's.

  public void emit(PrintWriter output){
    if(Location!=null)
      output.print("Location: "+Location+"\r\n");
    if(ProxyAuthenticate!=null)
      output.print("Proxy-Authenticate: "+ProxyAuthenticate+"\r\n");
    if(Public!=null)
      output.print("Public: "+Public+"\r\n");
    if(RetryAfter!=null)
      output.print("Retry-After: "+RetryAfter+"\r\n");
    if(Server!=null)
      output.print("Server: "+Server+"\r\n");
    if(Vary!=null)
      output.print("Vary: "+Vary+"\r\n");
    if(WWWAuthenticate!=null)
      output.print("WWW-Authenticate: "+WWWAuthenticate+"\r\n");
   if(Range!=null)
     output.print("Range: "+Range+"\r\n");
   if(Scale!=-1)
     output.print("Scale: "+Scale+"\r\n");
   if(Session!=-1)
     output.print("Session: "+Session+"\r\n");
   if(Speed!=-1)
     output.print("Speed: "+Speed+"\r\n");

  } 

  //method useful to get and set attributes headers.

  public void setLocation(String Location){
    this.Location=Location;
  }

 public void setProxyAuthenticate(String ProxyAuthenticate){
    this.ProxyAuthenticate=ProxyAuthenticate;
  }

 public void setPublic(String Public){
    this.Public=Public;
  }

 public void setRetryAfter(String RetryAfter){
    this.RetryAfter=RetryAfter;
  }

 public void setServer(String Server){
    this.Server=Server;
  }

 public void setVary(String Vary){
    this.Vary=Vary;
  }

 public void setWWWAuthenticate(String WWWAuthenticate){
    this.WWWAuthenticate=WWWAuthenticate;
  }

  // public void setAllow(String Allow){
  // this.Allow=Allow;
  // }

  // public void setCacheControl(String CacheControl){
  //  this.CacheControl=CacheControl;
  // }

  // public void setConnection(String Connection){
  //  this.Connection=Connection;
  // }

  // public void setDate(RtspDate date){
  //  this.date=date;
  // }

  public void setRange(String Range){
    this.Range=Range;
  }

 public void setScale(int Scale){
    this.Scale=Scale;
  }

  public void setSession(int Session){
    this.Session=Session;
  }

  public void setSpeed(int Speed){
    this.Speed=Speed;
  }

  // public void setVia(String Via){
  //   this.Via=Via;
  // }

  public String getLocation(){
    return Location;
  }

 public String getProxyAuthenticate(){
    return ProxyAuthenticate;
  }

 public String getPublic(){
    return Public;
  }

 public String getRetryAfter(){
   return this.RetryAfter;
  }

 public String getServer(){
    return Server;
  }

 public String getVary(){
    return Vary;
  }

 public String getWWWAuthenticate(){
    return WWWAuthenticate;
  }

  //public String setAllow(){
  //   return this.Allow;
  // }

  // public String  getCacheControl(){
  //  return this.CacheControl;
  // }

  // public String getConnection(){
  // return this.Connection;
  // }

  // public RtspDate getDate(){
  // return  this.date;
  //  }

 public String getRange(){
    return this.Range;
  }

  public int getScale(){
    return this.Scale;
  }

  public int getSession(){
    return this.Session;
  }

  public int getSpeed(){
    return this.Speed;
  }
 
// public String getVia(){
//    return this.Via;
//  }
}



