package w3c.rtsp.common;

import java.io.*;
import java.util.*;
import java.net.*;
import java.awt.*;


public class RequestLine {

  protected String method=null;
  protected RtspURL UrlRequest=null;
  protected String Version=null;
  protected int SeqNo=-1;

  public RequestLine(String method,
		     RtspURL UrlRequest,
		     String Version,
		     int SeqNo){
    this.Version=Version;
    this.SeqNo=SeqNo;
    this.method=method;
    this.UrlRequest=UrlRequest;
  }

  //set the version value.

  public void setVersion(String Version){
    this.Version=Version;
  }

  //set the method value. 

  public void setMethod(String method){
    this.method=method;
  }

  //set the SeqNo value.

  public void setSeqNo(int SeqNo){
    this.SeqNo=SeqNo;
  }

  //set the URL request  value.

  public void setUrlRequest(RtspURL UrlRequest){
    this.UrlRequest=UrlRequest;
  }

  //get the version value.

  public String getVersion(){
    return Version;
  }

  //get the method  value. 

  public String getMethod(){
    return method;
  }

  //get the SeqNo value.

  public int getSeqNo(){
    return SeqNo;
  }

  //get the Url request value.

  public RtspURL getUrlRequest(){
    return UrlRequest;
  }

  public void emit(PrintWriter output){
    // System.out.print("\nMETHOD : "+method+"\n");
    output.print(method+" ");
    UrlRequest.emit(output);
    output.print(" ");
    output.print(Version+" ");
    output.print(SeqNo+"\r\n");
  }
}
