package w3c.rtsp.common;

import java.io.*;
import java.util.*;
import java.net.*;
import java.awt.*;


public class RequestHeader {

  protected String Accept=null;
  protected String AcceptEncoding=null;
  protected String AcceptLanguage=null;
  protected String Authorization=null;
  protected int BandWidth=-1;

  //  protected String CacheControl=null;
  protected int BlockSize=-1;
  protected String Conference=null;
  protected String From=null;

  //  protected String Connection=null;
  //  protected RtspDate date=null;
  protected RtspDate IfModifiedSince=null;
  protected String Range=null;
  //  protected String Require=null;
  protected String Referer=null;
  protected int Scale=-1;
  protected int Session=-1;
  protected int Speed=-1;
  // protected String TransportRequire=null;
  protected String UserAgent=null;
  // protected String Via=null;


  public RequestHeader(){
  }

  public void setAccept(String Accept){
    this.Accept=Accept;
  }

  public void setAcceptEncoding(String AcceptEncoding){
    this.AcceptEncoding=AcceptEncoding;
  }

  public void setAcceptLanguage(String AcceptLanguage){
    this.AcceptLanguage=AcceptLanguage;
  }

  public void setAuthorization(String Authorization){
    this.Authorization=Authorization;
  }

  public void setBandWidth(int BandWidth){
    this.BandWidth=BandWidth;
  }

  //  public void setCacheControl(String CacheControl){
  //   this.CacheControl=CacheControl;
  // }

  public void setBlockSize(int BlockSize){
    this.BlockSize=BlockSize;
  }

  public void setConference(String Conference){
    this.Conference=Conference;
  }

  // public void setConnection(String Connection){
  // this.Connection=Connection;
  // }

  //public void setDate(RtspDate date){
  //  this.date=date;
  // }

  public void setFrom(String From){
    this.From=From;
  }

  public void setIfModifiedSince(RtspDate IfModifiedSince){
    this.IfModifiedSince=IfModifiedSince;
  }

  public void setRange(String Range){
    this.Range=Range;
  }

  //  public void setRequire(String Require){
  // this.Require=Require;
  // }

  public void setReferer(String Referer){
    this.Referer=Referer;
  }

  public void setScale(int Scale){
    this.Scale=Scale;
  }

  public void setSession(int Session){
    this.Session=Session;
  }

  public void setSpeed(int Speed){
    this.Speed=Speed;
  }

  //public void setTransportRequire(String TransportRequire){
  //  this.TransportRequire=TransportRequire;
  // }

  public void setUserAgent(String UserAgent){
    this.UserAgent=UserAgent;
  }

  // public void setVia(String Via){
  //  this.Via=Via;
  // }

  public String getAccept(){
    return this.Accept;
  }

  public String getAcceptEncoding(){
    return this.AcceptEncoding;
  }

 public String getAcceptLanguage(){
    return this.AcceptLanguage;
  }

  public String  getAutorization(){
    return this.Authorization;
  }

  public int getBandWidth(){
    return this.BandWidth;
  }

  // public String  getCacheControl(){
  //   return this.CacheControl;
  // }

  public int getBlockSize(){
    return this.BlockSize;
  }

  public String getConference(){
    return this.Conference;
  }

  //public String getConnection(){
  //  return this.Connection;
  //}

  //public RtspDate getDate(){
  // return  this.date;
  // }

  public RtspDate getIfModifiedSince(){
    return this.IfModifiedSince;
  }

  public String getRange(){
    return this.Range;
  }

  // public String  getRequire(){
  //   return this.Require;
  // }

  public String getReferer(){
    return this.Referer;
  }

  public int getScale(){
    return this.Scale;
  }

  public int getSession(){
    return this.Session;
  }

  public int getSpeed(){
    return this.Speed;
  }

  // public String getTransportRequire(){
  //  return this.TransportRequire;
  // }

  public String getUserAgent(){
    return this.UserAgent;
  }

  //public String getVia(){
  //  return this.Via;
  // }
   
  public void emit(PrintWriter output){
    if(this.Accept!=null)
      output.print("Accept: "+this.Accept+"\r\n");
  if(AcceptEncoding!=null)
      output.print("Accept-Encoding: "+AcceptEncoding+"\r\n");
  if(AcceptLanguage!=null)
      output.print("Accept-Language: "+AcceptLanguage+"\r\n");
    if(Authorization!=null)
      output.print("Authorization: "+Authorization+"\r\n");
    if(BandWidth!=-1)
      output.print("BandWidth: "+BandWidth+"\r\n");
    //  if(CacheControl!=null)
    // output.print("Cache-Control: "+CacheControl+"\r\n");
    if(BlockSize!=-1)
      output.print("BlockSize: "+BlockSize+"\r\n");
    if(Conference!=null)
      output.print("Conference: "+Conference+"\r\n");
    // if(Connection!=null)
    //  output.print("Connection: "+Connection+"\r\n");
    // if(date!=null)
    //  output.print("Date: "+date.weekday+", "+date.GMTDate+"\r\n");
    if(IfModifiedSince!=null)
      output.print("If-Modified-Since: "+IfModifiedSince.weekday+","+IfModifiedSince.GMTDate+"\r\n");
    if(Range!=null)
      output.print("Range: "+Range+"\r\n");
    //if(Require!=null)
    //  output.print("Require: "+Require+"\r\n");
    if(Referer!=null)
      output.print("Referer: "+Referer+"\r\n");
    if(Scale!=-1)
      output.print("Scale: "+Scale+"\r\n");
    if(Session!=-1)
      output.print("Session: "+Session+"\r\n");
    if(Speed!=-1)
      output.print("Speed: "+Speed+"\r\n");
    // if(TransportRequire!=null)
    //  output.print("Transport-Require: "+TransportRequire+"\r\n");
    if(UserAgent!=null)
      output.print("User-Agent: "+UserAgent+"\r\n");
    // if(Via!=null)
    //  output.print("Via: "+Via+"\r\n");
 }
}
