// Range.java
// $Id: Range.java,v 1 1997/07/31 10:00 osofia Exp $
// (c) COPYRIGHT MIT and INRIA, 1997.
// Please first read the full copyright statement in file COPYRIGHT.html


package w3c.rtsp.common;

import java.io.*;
import java.util.*;
import java.net.*;
import java.awt.*;


public class Range {

  //range is only the range specifier.(without "Range:")
  
  protected Smpte start=null;
  protected Smpte stop=null;
  protected String range=null;

  //cut the string part range.



  //test if the specifier is Smpte.

  public boolean isSmpte(){
    if(this.range!=null)
      return (this.range.startsWith("smpte="));
    else
      return false;
  }

  //test if the specifier is npt.

  public boolean isNpt(){
    if(this.range!=null)
      return (this.range.startsWith("npt="));
    else
      return false;
  }

  //test if the specifier is utc

  public boolean isUtc(){
    if(this.range!=null)
      return (this.range.startsWith("clock="));
    else
      return false;
  }

  //return a string representation of a Objetc range.

  public String toString(){
    return new String(this.start.toString()+"-"+this.stop.toString());
  }

  //return the difference between the start and the stop value.
  //The result is transformed in Smpte format.

  public Smpte differ(){
    int tmp=0;
    if(this.stop!=null){
      tmp=(this.stop.hour*3600+this.stop.min*60+this.stop.sec)
	-(this.start.hour*3600+this.start.min*60+this.start.sec);
      return new Smpte(tmp);
    }
    else 
      return this.start;
  }

  //constructors.

  public Range(String str){
    String [] tab=new String[4];
    int i=0;
    try{
      if(str.indexOf('/')!=-1){
	StringTokenizer stk=new StringTokenizer(str,"/");
      	while(stk.hasMoreTokens())
	  tab[i++]=stk.nextToken();
	System.out.println("\nTAB:"+tab.toString());
	this.start=new Smpte(tab[0]);
	if(tab[1]!=null)
	  this.stop=new Smpte(tab[1]);
      }
      if(str.indexOf('-')!=-1){
	StringTokenizer stk=new StringTokenizer(str,"-");
	while(stk.hasMoreTokens())
	  tab[i++]=stk.nextToken();
	System.out.println("\nTAB:"+tab.toString());
	this.start=new Smpte(tab[0]);
	if(tab[1]!=null)
	  this.stop=new Smpte(tab[1]);
      }
    }catch(SmpteException E){
      E.printStackTrace();
    }
    //    System.out.println("\nDIFF:"+this.differ().toString());
  }

  public Range(Smpte start,Smpte stop){
    this.start=start;
    this.stop=stop;
  }


}
