// ImageCache.java
// $Id: ImageCache.java,v 1.2 1997/05/21 15:43:49 ylafon Exp $
// Author: Jean-Michel.Leon@sophia.inria.fr
// (c) COPYRIGHT MIT and INRIA, 1997.
// Please first read the full copyright statement in file COPYRIGHT.html

//Modified by Olivier Sofia

package w3c.rtsp.common;

import java.awt.*;
import java.util.*;


/**
 * A Basic Image Cache class.
 */
public class ImageCache {
    private static Hashtable images = new Hashtable();

   /**
    * Gets an Image of the requested size.
    *
    * Checks if an Image already exists in the cache for the current Thread and
    * if this image is large enough. Else, creates a new Image and store it in
    * the cache.
    */
    static public Image getImage(Component c, int w, int h) {
	Image img = (Image)images.get(Thread.currentThread());
	if((img == null) || (img.getWidth(c) < w) || (img.getHeight(c) < h)) {
	    img = c.createImage(w, h);
	    images.put(Thread.currentThread(), img);
	}
	return img;
    }
}
