package w3c.rtsp.common;

import java.io.*;
import java.util.*;
import java.net.*;
import java.awt.*;


public class GeneralHeader {

 protected String CacheControl=null;
 protected String Connection=null;
 protected RtspDate date;
 protected String Via=null;


  public GeneralHeader(){
    this.date=new RtspDate();
  }

 public GeneralHeader(Date date){
    this.date=new RtspDate(date);
  }

 public void emit(PrintWriter output){
   if(CacheControl!=null)
     output.print("Cache-Control: "+CacheControl+"\r\n");
   if(Connection!=null)
     output.print("Connection: "+Connection+"\r\n");
   if(date.weekday!=null)
     output.print("Date: "+date.weekday+", "+date.GMTDate+"\r\n");
   if(Via!=null)
     output.print("Via: "+Via+"\r\n");
  } 

  public void setCacheControl(String CacheControl){
    this.CacheControl=CacheControl;
  }
  
  public void setConnection(String Connection){
    this.Connection=Connection;
  }

  public void setDate(RtspDate date){
    this.date=date;
  }

  public void setVia(String Via){
    this.Via=Via;
  }

  public String  getCacheControl(){
    return this.CacheControl;
  }

  public String getConnection(){
    return this.Connection;
  }

  public RtspDate getDate(){
    return  this.date;
  }

  public String getVia(){
    return this.Via;
  }
}
