// EntityHeader.java
// $Id: EntityHeader.java,v 1 1997/07/10 15:00 osofia Exp $
// (c) COPYRIGHT MIT and INRIA, 1997.
// Please first read the full copyright statement in file COPYRIGHT.html

package w3c.rtsp.common;

import java.io.*;
import java.util.*;
import java.net.*;
import java.awt.*;


public class EntityHeader {

  protected String Allow=null;
  protected String ContentEncoding = null;
  protected String ContentLanguage = null;
  protected int ContentLength = 0;
  protected String ContentType = null;
  protected String Expires =null;
  protected String LastModified=null;
  protected String ExtensionHeader = null;
  //protected String AcceptLanguage=null;


  public EntityHeader(String ContentEncoding){
    this.ContentEncoding=ContentEncoding;
  }

  public EntityHeader(){
  }

  public void emit(PrintWriter output){
    if(Allow!=null)
      output.print("Allow: "+Allow+"\r\n");
    if(ContentEncoding!=null)
      output.print("Content-Encoding: "+ContentEncoding+"\r\n");
    if(ContentLanguage!=null)
      output.print("Content-Language: "+ContentLanguage+"\r\n");
    //   if(ContentLength!=0)
      output.print("Content-Length: "+ContentLength+"\r\n");
    if(ContentType!=null)
      output.print("Content-Type: "+ContentType+"\r\n");
    if(Expires!=null)
      output.print("Expires: "+Expires+"\r\n");
    if(LastModified!=null)
      output.print("Last-Modified: "+LastModified+"\r\n");
    if(ExtensionHeader!=null)
      output.print("Extension-Header: "+ExtensionHeader+"\r\n");
    //if(AcceptLanguage!=null)
    //   output.print("Accept-Language: "+AcceptLanguage+"\r\n");
  }

  public EntityHeader(String ContentEncoding,
		      String ContentLanguage,
		      int ContentLength,
		      String ContentType,
		      String Expires,
		      String LastModified,
		      String ExtensionHeader
		      ){

    this.ContentEncoding=ContentEncoding;
    this.ContentLanguage=ContentLanguage;
    this.ContentLength=ContentLength;
    this.ContentType=ContentType;
    this.Expires=Expires;
    this.LastModified=LastModified;
    this.ExtensionHeader=ExtensionHeader;
    // this.AcceptLanguage=AcceptLanguage;
  }

 public EntityHeader(String Alow,
		     String ContentEncoding,
		      String ContentLanguage,
		      int ContentLength,
		      String ContentType,
		      String Expires,
		      String LastModified,
		      String ExtensionHeader
		      ){
   this.Allow=Allow;
   this.ContentEncoding=ContentEncoding;
   this.ContentLanguage=ContentLanguage;
   this.ContentLength=ContentLength;
   this.ContentType=ContentType;
   this.Expires=Expires;
   this.LastModified=LastModified;
   this.ExtensionHeader=ExtensionHeader;
 }

 public void setAllow(String Allow){
    this.Allow=Allow;
 }

  public void setContentLength(int length){
    this.ContentLength=length;
  }

 public void setContentEncoding(String ContentEncoding){
    this.ContentEncoding=ContentEncoding;
  }

  public void setContentLanguage(String ContentLanguage){
    this.ContentLanguage=ContentLanguage;
  }

  public void setContentType(String ContentType){
    this.ContentType=ContentType;
  }

  public void setExpires(String Expires){
    this.Expires=Expires;
  }

  public void setLastModified(String LastModified){
    this.LastModified=LastModified;
  }

  public void setExtensionHeader(String ExtensionHeader){
    this.ExtensionHeader=ExtensionHeader;
  }

  public String getContentEncoding(){
    return ContentEncoding;
  }

  public String getContentLanguage(){
    return this.ContentLanguage;
  }

  public String setAllow(){
    return this.Allow;
  }

  public int getContentLength(){
    return this.ContentLength;
  }

  public String getContentType(){
    return this.ContentType;
  }

 public String getExpires(){
    return this.Expires;
  }

 public String getLastModified(){
    return this.LastModified;
  }

  public String getExtensionHeader(){
    return this.ExtensionHeader;
  }
}
