// Timer.java
// $Id: Timer.java,v 1 1997/08/01 10:00 osofia Exp $
// (c) COPYRIGHT MIT and INRIA, 1997.
// Please first read the full copyright statement in file COPYRIGHT.html

package w3c.rtsp.client;

import java.io.*;
import java.util.*;
import java.net.*;
import java.awt.*;
import w3c.rtsp.common.*;

abstract public class Timer extends Thread {
  public final static int THREAD_PRIORITY = 1;
  public long timeout = 0;

  abstract public void handleEvent();

  protected boolean waitTimeout() {
    long stop = System.currentTimeMillis() + timeout;
    while(true) {
      if (System.currentTimeMillis() > stop)
        return true;
    }
  }
  
  public void run() {
    while( true ) {
      if (waitTimeout())
        handleEvent();
    }
  }

  public Timer(long timeout) {
    this.timeout = timeout;
    setName("Timer");
    setDaemon(true);
    setPriority(THREAD_PRIORITY);
  }
  
}

