// RtspClient.java
// $Id: RtspClient.java,v 1 1997/06/10 15:00 osofia Exp $
// (c) COPYRIGHT MIT and INRIA, 1997.
// Please first read the full copyright statement in file COPYRIGHT.html

package w3c.rtsp.client;

import java.io.*;
import java.net.*;
import java.util.*;
import w3c.rtsp.common.*;

public class RtspClient {

 public  Socket socket = null ;
 public  DataInputStream input = null ;
 public  PrintWriter output = null ;
 public  RtspReceive receive=null;
 public  RtspState state=null;
 public  Process p=null;
 protected int nb_seq=0;
 public int session_nb=-1;
 protected int code=-1;  
 protected Sdp sdpObj=null;

  public RtspClient(String ServerHost,int port) throws ConnectException {
    try{
      socket=new Socket(ServerHost,port);
      input = new DataInputStream(socket.getInputStream());
      output = new PrintWriter(socket.getOutputStream());
    }catch(IOException E){
      System.out.println("\nSOCKET ERROR : "+E.getMessage());
      E.printStackTrace();
      throw new ConnectException("connection refused");
    }
    sdpObj=new Sdp();
    state=new RtspState("C");
    receive=new RtspReceive(input,output);
    receive.start();
  }
  
public void SendMessage(String message,String sample,int port){// throws MalformedURLException {
    int ch=-1;
    int resultState;
    try{
      RequestLine rl=new RequestLine(message,new RtspURL(sample),"RTSP/1.0",nb_seq);
      RequestHeader reqH=new RequestHeader();
      GeneralHeader genH=new GeneralHeader(new Date());

      this.increaseSeqNo();
      TransportHeader th=new TransportHeader("udp/rtp",port);
      EntityHeader eh=new EntityHeader();
      RtspRequest request=new RtspRequest(rl,genH,reqH,eh,th,message);

      resultState=state.nextState(request.requestline.getMethod());
      if(resultState==0){
	request.emit(output);
	//reply is the response of request.
	//receive thread is jammed until the arrival of reply.
	
	RtspReply reply=receive.NotifyRequest(request);
	
	//change the client's state.
	
	if(reply.getStatusLine().getReasonPhrase().equals("OK"))
	  session_nb=reply.getResponseHeader().getSession();
      }
      else
	System.out.println("\nCAN'T MAKE THE REQUEST : "+request.requestline.getMethod());
    }
    catch(IOException E){
      System.out.println("\n SOCKET ERROR : "+E.getMessage());
      E.printStackTrace();
    }
  }

  //play the specified sample.

  public void Play(String sample) throws IOException { 
    int ch=-1;
    int resultState;
    try{

     //contruction of the request line.

      RequestLine rl=new RequestLine("PLAY",new RtspURL(sample),"RTSP/1.0",nb_seq);

      //construction of the request header.

      GeneralHeader genH=new GeneralHeader();
      RequestHeader reqH=new RequestHeader();
      reqH.setSession(session_nb);

      //set the range value to the request header if exist.
      
      RtspURL actual_url=new RtspURL(sample);

      //entity header construction.

      EntityHeader eh=new EntityHeader();

      //there is not a transport header to send.

      TransportHeader th=new TransportHeader();

      //construction of the complete request.

      RtspRequest request=new RtspRequest(rl,genH,reqH,eh,th,"PLAY");

      //now we are trying to play.At fisrt we have to change the client state's.

	resultState=state.nextState(request.requestline.getMethod());
	if(resultState==0){
	  request.emit(output);

	//reply is the response of request.
	//receive thread is jammed until the arrival of reply.
	
	RtspReply reply=receive.NotifyRequest(request);

	//we are setting the setting the Status code.

	setCode(reply.getStatusLine().getStatusCode());
	
	//we want to play a audio sample.

	if(reply.getStatusLine().getReasonPhrase().equals("OK"))
	  if((p==null)
	     &&
	     (request.requestline.getMethod().equals("PLAY"))
	     &&
	     (resultState==0))

	    ;//waiting the reply of request before Playing.
	}
	else
	  System.out.println("\nCAN'T MAKE THE REQUEST : "
			     +request.requestline.getMethod());
    }
    catch(IOException E){
      System.out.println("\n SOCKET ERROR : "+E.getMessage());
      E.printStackTrace();
      throw new IOException("File not found :");
    }
	
    //the sequence number has to be icrease.
    
    this.increaseSeqNo();
 }

  //stopping the stream using the method TEARDOWN.

  public void Stop(String sample) {
    int resultState;
    try{

      //contruction of the request line.

      RequestLine rl=new RequestLine("TEARDOWN",new RtspURL(sample),"RTSP/1.0",nb_seq);
      this.increaseSeqNo();
      GeneralHeader genH=new GeneralHeader();
      RequestHeader reqH=new RequestHeader();
      reqH.setSession(session_nb);

      EntityHeader eh=new EntityHeader();
  
      //there is not a transport header to send.

    TransportHeader th=new TransportHeader();


    //construction of the complete request.
     
    RtspRequest request=new RtspRequest(rl,genH,reqH,eh,th,"TEARDOWN");
    
    //we have to test the session number.
    
    resultState=state.nextState(request.requestline.getMethod());
    if(resultState==0){
      request.emit(output);

   //reply is the response of request.
    //receive thread is jammed until the arrival of reply.

    RtspReply reply=receive.NotifyRequest(request);

    //we are setting the setting the Status code.
    
    setCode(reply.getStatusLine().getStatusCode());

    }
    else
      System.out.println("\nCAN'T MAKE THE REQUEST : "+request.requestline.getMethod());
    }
    catch(IOException E){
      System.out.println("\n SOCKET ERROR : "+E.getMessage());
      E.printStackTrace();
    }
 }

  public void Describe(String sample) throws IOException { //MalformedURLException{
    int ch=-1;
    try{

      //contruction of the request line.

      RequestLine rl=new RequestLine("DESCRIBE",new RtspURL(sample),"RTSP/1.0",nb_seq);

      //construction of the request header.

      GeneralHeader genH=new GeneralHeader();
      RequestHeader reqH=new RequestHeader();
      reqH.setSession(session_nb);

      //entity header construction.

      EntityHeader eh=new EntityHeader();

      //there is not a transport header to send.

      TransportHeader th=new TransportHeader();

      //construction of the complete request.

      RtspRequest request=new RtspRequest(rl,genH,reqH,eh,th,"");

      //Describe has no action on the client state's.

      request.emit(output);
      
      //reply is the response of request.
      //receive thread is jammed until the arrival of reply.
      
      RtspReply reply=receive.NotifyRequest(request);

      //we are setting the setting the Status code.
      
      setCode(reply.getStatusLine().getStatusCode());

      try{
	this.sdpObj=new Sdp();
	this.sdpObj.parse(reply.getBodyMessage());
      }catch(SdpException E){
	E.printStackTrace();
      }

      //we are setting the setting the Status code.
      
    } catch(IOException E){
      System.out.println("\n SOCKET ERROR : "+E.getMessage());
      E.printStackTrace();
      throw new IOException("File not found :");
    }
	
    //the sequence number has to be icrease.
    
    this.increaseSeqNo();
 }

  //treat the method pause.

  public void Pause(String sample){
    int resultState;
    try{
      RequestLine rl=new RequestLine("PAUSE",new RtspURL(sample),"RTSP/1.0",nb_seq);
      this.increaseSeqNo();
      EntityHeader eh=new EntityHeader();
      RtspRequest request=new RtspRequest(rl,new GeneralHeader(),new RequestHeader(),eh,null,"TEARDOWN");
      {
	resultState=state.nextState(request.requestline.getMethod());
	if(resultState==0)
	  request.emit(output);
	else
	  System.out.println("\nCAN'T MAKE THE REQUEST : "+request.requestline.getMethod());

	//reply is the response of request.
	//receive thread is jammed until the arrival of reply.
	
	RtspReply reply=receive.NotifyRequest(request);
      }
    }
    catch(IOException E){
      System.out.println("\n SOCKET ERROR : "+E.getMessage());
      E.printStackTrace();
    }
  }

  public void increaseSeqNo(){
    nb_seq++;
  }

  public void setCode(int code){
    this.code=code;
  }

  public int getCode(){
    return this.code;
  }

  public Sdp getSdpObj(){
    return this.sdpObj;
  }
}






