// DialogBox.java
// $Id: DialogBox.java,v 1.10 1997/08/7 12:54:18 osofia Exp $
// (c) COPYRIGHT MIT and INRIA, 1997.
// Please first read the full copyright statement in file COPYRIGHT.html

package w3c.rtsp.client;

import java.io.*;
import java.util.*;
import java.net.*;
import java.awt.*;
import java.awt.event.*;
import w3c.rtsp.common.*;


//class DialogBox is the implementation of differents kinds of DialogBox.

public  class DialogBox {

    protected mediascape app=null;
    protected Button OK = null;
    protected Dialog dialogCreate = null;
    protected Label createLabel = null;
    protected TextField sample=null;
    protected TextField audiotextprog=null;
    protected TextField videotextprog=null,textproto=null,textport=null;
    protected Button CANCEL = null;
    protected Button DEFAULT = null;
    protected Button save=null;
    protected Button DELETE=null;
    protected Choice mychoice=null;
    protected TextField item=null;
    protected MyActionListener myListener=null;
   
    public DialogBox(String messageBox,mediascape app){
  
      this.app=app;
      this.myListener=app.myListener;
      GridBagLayout layout = new GridBagLayout();
      GridBagConstraints Constraints = new GridBagConstraints();
      Panel P = new Panel(layout);
      Constraints.insets = new Insets(0,0,10,0);
      Constraints.anchor=GridBagConstraints.CENTER;
      Constraints.gridwidth = GridBagConstraints.REMAINDER;

      Label l = new Label(messageBox);
      layout.setConstraints(l,Constraints);
      P.add(l);

      createLabel = new Label();
      layout.setConstraints(createLabel,Constraints);
      P.add(createLabel);

      Panel P2 = new Panel();
      OK  = new Button("Ok");
      P2.add(OK);
      layout.setConstraints(P2,Constraints);
      P.add(P2);

      OK.addActionListener(myListener);
    
      dialogCreate = new Dialog(new Frame(),"Open");
      dialogCreate.add(P);
      dialogCreate.setSize(400,100);
    }

   public DialogBox(mediascape app,String st){
  
      this.app=app;
      this.myListener=app.myListener;
      GridBagLayout layout = new GridBagLayout();
      GridBagConstraints Constraints = new GridBagConstraints();
      Panel P = new Panel(layout);
      Constraints.insets = new Insets(0,0,10,0);
      Constraints.anchor=GridBagConstraints.CENTER;
      Constraints.gridwidth = GridBagConstraints.REMAINDER;

      Label l0 = new Label(st);
      layout.setConstraints(l0,Constraints);
      P.add(l0);

      createLabel = new Label();
      layout.setConstraints(createLabel,Constraints);
      P.add(createLabel);

      Panel P2 = new Panel();
      this.OK  = new Button("Ok");
      P2.add(OK);
      layout.setConstraints(P2,Constraints);
      this.CANCEL  = new Button("CANCEL");
      P2.add(CANCEL);
      layout.setConstraints(P2,Constraints);
      P.add(P2);

      OK.addActionListener(myListener);
      this.CANCEL.addActionListener(myListener);
    
      dialogCreate = new Dialog(new Frame(),"RTSP COMMENT");
      dialogCreate.add(P);
      dialogCreate.setSize(400,150);
    }


  public DialogBox(String messageBox,TextField address,mediascape app){
    
      this.app=app;
      this.myListener=app.myListener;
      this.sample=address;
      GridBagLayout layout = new GridBagLayout();
      GridBagConstraints Constraints = new GridBagConstraints();
      Panel P = new Panel(layout);
      Constraints.insets = new Insets(0,0,10,0);
      Constraints.anchor=GridBagConstraints.CENTER;
    

      Label l = new Label(messageBox);
      layout.setConstraints(l,Constraints);
      P.add(l);

      Constraints.gridwidth = GridBagConstraints.REMAINDER;
      layout.setConstraints(this.sample,Constraints);
      P.add(this.sample);

      createLabel = new Label();
      layout.setConstraints(createLabel,Constraints);
      P.add(createLabel);

      Panel P2 = new Panel();
      OK  = new Button("Ok");
      P2.add(OK);
      layout.setConstraints(P2,Constraints);
      P.add(P2);

      OK.addActionListener(myListener);
    
      dialogCreate = new Dialog(new Frame(),"RTSP COMMENT");
      dialogCreate.add(P);
      dialogCreate.setSize(430,160);
    }

   //constructor of the delete bookmarks box.

   public DialogBox(Choice mychoice,mediascape app){

     this.app=app;
     this.myListener=app.myListener;
     this.item=new TextField(30);
     this.mychoice=mychoice;
     
     GridBagLayout layout = new GridBagLayout();
     GridBagConstraints Constraints = new GridBagConstraints();
     GridBagConstraints Constraints1 = new GridBagConstraints();
     Panel P = new Panel(layout);
     Constraints.insets = new Insets(0,0,10,0);
     Constraints.anchor=GridBagConstraints.CENTER;
     Constraints1.anchor=GridBagConstraints.CENTER;

     Label l = new Label("URL : ");
     layout.setConstraints(l,Constraints);
     P.add(l);
      
     Constraints1.gridwidth = GridBagConstraints.REMAINDER;
     layout.setConstraints(this.item,Constraints1);
     P.add(this.item);
     
     Label l1 = new Label("Bookmars Url : ");
     layout.setConstraints(l1,Constraints);
     P.add(l1);
     
     Constraints1.gridwidth = GridBagConstraints.REMAINDER;
     layout.setConstraints(this.mychoice,Constraints1);
     P.add(this.mychoice);
     
     Panel P2 = new Panel();
     CANCEL = new Button("CANCEL");
     P2.add(CANCEL);
     DELETE  = new Button("DELETE");
     P2.add(DELETE);
     layout.setConstraints(P2,Constraints);
     P.add(P2);
     
     createLabel = new Label();
     layout.setConstraints(createLabel,Constraints);
     P.add(createLabel);

     DELETE.addActionListener(myListener);
     CANCEL.addActionListener(myListener);
     this.item.addActionListener(myListener);

     dialogCreate = new Dialog(new Frame(),"BOOKMARKS COMMENT");
     dialogCreate.add(P);
     dialogCreate.setSize(430,160);
   }

  public TextField getItem(){
    return this.item;
  }

  public Choice getChoice(){
    return  this.mychoice;
  }

   //constructor.

  public DialogBox(TextField audioprog,
		   TextField videoprog,
		   TextField proto,
		   TextField p,
		   mediascape app){
      this.app=app;  
      this.myListener=app.myListener;
      this.audiotextprog=audioprog;
      this.videotextprog=videoprog;
      this.textproto=proto;
      this.textport=p;

      GridBagLayout layout = new GridBagLayout();
      GridBagConstraints Constraints = new GridBagConstraints();
      GridBagConstraints Constraints1 = new GridBagConstraints();
      Panel P = new Panel(layout);
      Constraints.insets = new Insets(0,0,10,0);
      Constraints.anchor=GridBagConstraints.CENTER;
      Constraints1.anchor=GridBagConstraints.CENTER;

      Label l = new Label("Audio program used : ");
      layout.setConstraints(l,Constraints);
      P.add(l);
      
      Constraints1.gridwidth = GridBagConstraints.REMAINDER;
      layout.setConstraints(this.audiotextprog,Constraints1);
      P.add(this.audiotextprog);

      Label l3 = new Label("Video program used : ");
      layout.setConstraints(l3,Constraints);
      P.add(l3);
      
      Constraints1.gridwidth = GridBagConstraints.REMAINDER;
      layout.setConstraints(this.videotextprog,Constraints1);
      P.add(this.videotextprog);
      
      Label l1 = new Label("Protocol used : ");
      layout.setConstraints(l1,Constraints);
      P.add(l1);
      
      layout.setConstraints(this.textproto,Constraints1);
      P.add(this.textproto);

      Label l2 = new Label("Port used : ");
      layout.setConstraints(l2,Constraints);
      P.add(l2);
      
      layout.setConstraints(this.textport,Constraints1);
      P.add(this.textport);

      createLabel = new Label();
      layout.setConstraints(createLabel,Constraints);
      P.add(createLabel);

      Panel P2 = new Panel();
      this.OK  = new Button("   Ok   ");
      P2.add(OK);
     
      this.CANCEL=new Button("CANCEL ");
      P2.add(this.CANCEL);
      layout.setConstraints(P2,Constraints);

      this.DEFAULT=new Button("Default");
      P2.add(this.DEFAULT);
      layout.setConstraints(P2,Constraints);
      P.add(P2);

      this.OK.addActionListener(myListener);
      this.CANCEL.addActionListener(myListener);
      this.DEFAULT.addActionListener(myListener);

      dialogCreate = new Dialog(new Frame(),"RTSP Receiver Config");
      dialogCreate.add(P);
      dialogCreate.setSize(430,250);
    }

   //Display the dialog Box.

    public void display (String service) {
      createLabel.setText(service);
      dialogCreate.show();
    }

   //Hide the dialog Box.

    public void hide() {
      dialogCreate.setVisible(false);
    }

   //Refresh the value set int the dialog Box.

    public void refresh(){
      textport.setText(Integer.toString(app.port_nb));
      audiotextprog.setText(app.audio_prog_used);
      videotextprog.setText(app.video_prog_used);
      textproto.setText(app.stream_protocol);
    }

   //return the adress value.

    public String getAddress(){
      return this.sample.getText();
    }
   
   //return the sample value.

    public TextField getSample(){
      return this.sample;
    }

   //return the value set in the textfield audiotext.

    public TextField getAudioProgText(){
      return this.audiotextprog;
    }

   //return the value set in the textfield Porttext.

    public TextField getPortText(){
      return this.textport;
    }

   //return the value set in the textfield prototext.

    public TextField getProtoText(){
      return this.textproto;
    }

}
