// ConfigCommand.java
// $Id: ConfigCommand.java,v 1.8 1997/06/17 13:08:45 bmahe Exp $
// (c) COPYRIGHT MIT and INRIA, 1996.
// Please first read the full copyright statement in file COPYRIGHT.html

package w3c.jigsaw.ssi ;

import java.util.* ;

import w3c.util.* ;
import w3c.jigsaw.http.* ;
import w3c.jigsaw.resources.* ;

/**
 * Implementation of the <code>config</code> SSI command.
 * Used to set the <code>sizefmt</code> and <code>datefmt</code> variables,
 * which control the output of file sizes and dates.
 * @author Antonio Ramirez <anto@mit.edu>
 */
public class ConfigCommand implements Command {
    private final static String NAME = "config" ;

    public Reply execute(SSIResource resource,
			 Request request,
			 ArrayDictionary parameters,
			 Dictionary variables)
    {
	String parName = null, parValue = null ;

	for(int i=0;i<parameters.capacity();i++) {
	    parName = (String) parameters.keyAt(i) ;
	    if(parName==null) continue ;

	    parValue = (String) parameters.elementAt(i) ;

	    // Check to see if parameters and/or values are permissible
	    if(parName.equals("sizefmt")) {
		if(!parValue.equalsIgnoreCase("bytes")
		   && !parValue.equalsIgnoreCase("abbrev"))
		    continue ;
		else variables.put(parName,parValue.toLowerCase()) ;
	    } else if(parName.equals("datefmt")) {
		variables.put(parName,parValue) ;
	    }
	}
	
	return null ;
    }
    

    public String getName()
    {
	return NAME;
    }

  public String getValue(Dictionary variables, String variable) {
    return "null";
  }

}
