// ResourceContext.java
// $Id: ResourceContext.java,v 1.1 1997/03/07 13:03:36 abaird Exp $
// (c) COPYRIGHT MIT and INRIA, 1996, 1997.
// Please first read the full copyright statement in file COPYRIGHT.html

package w3c.jigsaw.resources;

import java.util.*;

import w3c.jigsaw.http.*;

public class ResourceContext {
    /**
     * Our parent context, if any.
     */
    protected ResourceContext parent = null;
    /**
     * The set of registered modules.
     */
    public Hashtable modules = null;
    /**
     * The server context of that resource context.
     */
    protected httpd server = null;

    /**
     * Get the server this context is attached to.
     * @return An httpd instance (guaranteed not to be <strong>null</strong>.
     */

    public httpd getServer() {
	return server;
    }

    /**
     * Get that context's ancestor.
     * @return A ResourceContext instance, or <strong>null</strong>.
     */

    public ResourceContext getParent() {
	return parent;
    }

    /**
     * Register a module within that resource context.
     * @param name The module's name.
     * @param impl The module's implementation.
     */

    public synchronized void registerModule(String name, Object impl) {
	if ( modules == null )
	    modules = new Hashtable(7);
	modules.put(name, impl);
    }

    /**
     * Lookup a module within that resource context.
     * @param name Name of the module to look for.
     * @param inherited Also look within the contexts hierarchy for an 
     * inherited module having that name.
     */

    public Object getModule(String name, boolean inherited) {
	Object impl = ((modules == null) ? null : modules.get(name));
	if (inherited && (parent != null) && (impl == null))
	    impl = parent.getModule(name, true);
	return impl;
    }

    /**
     * Lookup a module within that context, and up the hierarchy of contexts.
     * @param name The module's name.
     * @return An object <em>implementing</em> that module.
     */

    public Object getModule(String name) {
	return getModule(name, true);
    }
     
    public ResourceContext(ResourceContext parent) {
	this.parent = parent;
	this.server = (parent != null) ? parent.server : null;
    }

    public ResourceContext(httpd server) {
	this.server = server;
	this.parent = null;
    }
}
