// MuxClientFactory.java
// $Id: MuxClientFactory.java,v 1.2 1996/12/16 10:58:49 abaird Exp $
// (c) COPYRIGHT MIT and INRIA, 1996.
// Please first read the full copyright statement in file COPYRIGHT.html

package w3c.jigsaw.http.mux;

import java.io.*;
import java.net.*;

import w3c.www.mux.*;
import w3c.jigsaw.http.*;

public class MuxClientFactory implements ClientFactory {
    public static final int HTTP_PORT = 80;

    httpd              server  = null;
    int                cid     = -1;
    SampleMuxHandler   handler = null;
    MuxProtocolHandler httphandler = null;

    public void shutdown(boolean force) {
	System.out.println("Shutdown: not implemented.");
    }

    /**
     * Handle that new incomming connection.
     * Wrap the given socket into a MuxStream, the rest is handled magically.
     * @param socket The newly accepted socket.
     */

    public void handleConnection(Socket socket) {
	try {
	    new MuxStream(true
			  , handler
			  , socket);
	} catch (IOException ex) {
	    server.errlog(getClass().getName()
			  +": rejected newly accepted connection (IOerror): "
			  + ex.getMessage());
	}
    }

    /**
     * Create a suitable server socket for our server context.
     * @return A ServerSocket instance.
     * @exception IOException If some IO error occured while creating the
     * server socket.
     */

    public ServerSocket createServerSocket() 
	throws IOException
    {
	return new ServerSocket(server.getPort(), 128);
    }

    /**
     * Initialize the MUX client factory.
     * @param server The server context in which this factory is to run.
     */

    public void initialize(httpd server) {
	// Initialize the server itself:
	this.server  = server;
	// Configure the mux stream handler:
	handler     = (SampleMuxHandler) SampleMuxHandler.getStreamHandler();
	httphandler = new MuxHttpHandler(server);
	handler.registerHandler(HTTP_PORT, httphandler);
    }

    public MuxClientFactory() {
	super();
    }

}
